; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals none --version 5
; RUN: opt -p loop-vectorize -S %s | FileCheck --check-prefix=DEFAULT %s
; RUN: opt -p loop-vectorize  -prefer-predicate-over-epilogue=predicate-else-scalar-epilogue -S %s | FileCheck --check-prefix=PRED %s

target datalayout = "e-m:o-i64:64-i128:128-n32:64-S128"
target triple = "arm64-apple-macosx14.0.0"

define void @invar_cond_gep_store(ptr %dst, i32 %0) {
; DEFAULT-LABEL: define void @invar_cond_gep_store(
; DEFAULT-SAME: ptr [[DST:%.*]], i32 [[TMP0:%.*]]) {
; DEFAULT-NEXT:  [[ENTRY:.*]]:
; DEFAULT-NEXT:    br label %[[LOOP_HEADER:.*]]
; DEFAULT:       [[LOOP_HEADER]]:
; DEFAULT-NEXT:    [[IV:%.*]] = phi i64 [ 1, %[[ENTRY]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; DEFAULT-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; DEFAULT-NEXT:    [[CMP9:%.*]] = icmp eq i32 [[TMP0]], 0
; DEFAULT-NEXT:    br i1 [[CMP9]], label %[[THEN:.*]], label %[[LOOP_LATCH]]
; DEFAULT:       [[THEN]]:
; DEFAULT-NEXT:    [[GEP:%.*]] = getelementptr i32, ptr [[DST]], i64 [[IV_NEXT]]
; DEFAULT-NEXT:    store i32 1, ptr [[GEP]], align 4
; DEFAULT-NEXT:    br label %[[LOOP_LATCH]]
; DEFAULT:       [[LOOP_LATCH]]:
; DEFAULT-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV]], 100
; DEFAULT-NEXT:    br i1 [[EC]], label %[[EXIT:.*]], label %[[LOOP_HEADER]]
; DEFAULT:       [[EXIT]]:
; DEFAULT-NEXT:    ret void
;
; PRED-LABEL: define void @invar_cond_gep_store(
; PRED-SAME: ptr [[DST:%.*]], i32 [[TMP0:%.*]]) {
; PRED-NEXT:  [[ENTRY:.*]]:
; PRED-NEXT:    br label %[[LOOP_HEADER:.*]]
; PRED:       [[LOOP_HEADER]]:
; PRED-NEXT:    [[IV:%.*]] = phi i64 [ 1, %[[ENTRY]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; PRED-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; PRED-NEXT:    [[CMP9:%.*]] = icmp eq i32 [[TMP0]], 0
; PRED-NEXT:    br i1 [[CMP9]], label %[[THEN:.*]], label %[[LOOP_LATCH]]
; PRED:       [[THEN]]:
; PRED-NEXT:    [[GEP:%.*]] = getelementptr i32, ptr [[DST]], i64 [[IV_NEXT]]
; PRED-NEXT:    store i32 1, ptr [[GEP]], align 4
; PRED-NEXT:    br label %[[LOOP_LATCH]]
; PRED:       [[LOOP_LATCH]]:
; PRED-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV]], 100
; PRED-NEXT:    br i1 [[EC]], label %[[EXIT:.*]], label %[[LOOP_HEADER]]
; PRED:       [[EXIT]]:
; PRED-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 1, %entry ], [ %iv.next, %loop.latch ]
  %iv.next = add i64 %iv, 1
  %cmp9 = icmp eq i32 %0, 0
  br i1 %cmp9, label %then, label %loop.latch

then:
  %gep = getelementptr i32, ptr %dst, i64 %iv.next
  store i32 1, ptr %gep, align 4
  br label %loop.latch

loop.latch:
  %ec = icmp eq i64 %iv, 100
  br i1 %ec, label %exit, label %loop.header

exit:
  ret void
}

declare double @llvm.fabs.f64(double) #0

define void @loop_dependent_cond(ptr %src, ptr noalias %dst, i64 %N) {
; DEFAULT-LABEL: define void @loop_dependent_cond(
; DEFAULT-SAME: ptr [[SRC:%.*]], ptr noalias [[DST:%.*]], i64 [[N:%.*]]) {
; DEFAULT-NEXT:  [[ENTRY:.*]]:
; DEFAULT-NEXT:    [[TMP0:%.*]] = add i64 [[N]], 1
; DEFAULT-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[TMP0]], 4
; DEFAULT-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; DEFAULT:       [[VECTOR_PH]]:
; DEFAULT-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[TMP0]], 4
; DEFAULT-NEXT:    [[N_VEC:%.*]] = sub i64 [[TMP0]], [[N_MOD_VF]]
; DEFAULT-NEXT:    br label %[[VECTOR_BODY:.*]]
; DEFAULT:       [[VECTOR_BODY]]:
; DEFAULT-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[PRED_STORE_CONTINUE7:.*]] ]
; DEFAULT-NEXT:    [[TMP3:%.*]] = getelementptr double, ptr [[SRC]], i64 [[INDEX]]
; DEFAULT-NEXT:    [[TMP5:%.*]] = getelementptr double, ptr [[TMP3]], i32 0
; DEFAULT-NEXT:    [[TMP6:%.*]] = getelementptr double, ptr [[TMP3]], i32 2
; DEFAULT-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x double>, ptr [[TMP5]], align 8
; DEFAULT-NEXT:    [[WIDE_LOAD1:%.*]] = load <2 x double>, ptr [[TMP6]], align 8
; DEFAULT-NEXT:    [[TMP7:%.*]] = call <2 x double> @llvm.fabs.v2f64(<2 x double> [[WIDE_LOAD]])
; DEFAULT-NEXT:    [[TMP8:%.*]] = call <2 x double> @llvm.fabs.v2f64(<2 x double> [[WIDE_LOAD1]])
; DEFAULT-NEXT:    [[TMP9:%.*]] = fcmp ogt <2 x double> [[TMP7]], splat (double 1.000000e+00)
; DEFAULT-NEXT:    [[TMP10:%.*]] = fcmp ogt <2 x double> [[TMP8]], splat (double 1.000000e+00)
; DEFAULT-NEXT:    [[TMP11:%.*]] = extractelement <2 x i1> [[TMP9]], i32 0
; DEFAULT-NEXT:    br i1 [[TMP11]], label %[[PRED_STORE_IF:.*]], label %[[PRED_STORE_CONTINUE:.*]]
; DEFAULT:       [[PRED_STORE_IF]]:
; DEFAULT-NEXT:    store i32 0, ptr [[DST]], align 4
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE]]
; DEFAULT:       [[PRED_STORE_CONTINUE]]:
; DEFAULT-NEXT:    [[TMP12:%.*]] = extractelement <2 x i1> [[TMP9]], i32 1
; DEFAULT-NEXT:    br i1 [[TMP12]], label %[[PRED_STORE_IF2:.*]], label %[[PRED_STORE_CONTINUE3:.*]]
; DEFAULT:       [[PRED_STORE_IF2]]:
; DEFAULT-NEXT:    store i32 0, ptr [[DST]], align 4
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE3]]
; DEFAULT:       [[PRED_STORE_CONTINUE3]]:
; DEFAULT-NEXT:    [[TMP13:%.*]] = extractelement <2 x i1> [[TMP10]], i32 0
; DEFAULT-NEXT:    br i1 [[TMP13]], label %[[PRED_STORE_IF4:.*]], label %[[PRED_STORE_CONTINUE5:.*]]
; DEFAULT:       [[PRED_STORE_IF4]]:
; DEFAULT-NEXT:    store i32 0, ptr [[DST]], align 4
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE5]]
; DEFAULT:       [[PRED_STORE_CONTINUE5]]:
; DEFAULT-NEXT:    [[TMP14:%.*]] = extractelement <2 x i1> [[TMP10]], i32 1
; DEFAULT-NEXT:    br i1 [[TMP14]], label %[[PRED_STORE_IF6:.*]], label %[[PRED_STORE_CONTINUE7]]
; DEFAULT:       [[PRED_STORE_IF6]]:
; DEFAULT-NEXT:    store i32 0, ptr [[DST]], align 4
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE7]]
; DEFAULT:       [[PRED_STORE_CONTINUE7]]:
; DEFAULT-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; DEFAULT-NEXT:    [[TMP15:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; DEFAULT-NEXT:    br i1 [[TMP15]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; DEFAULT:       [[MIDDLE_BLOCK]]:
; DEFAULT-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[TMP0]], [[N_VEC]]
; DEFAULT-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; DEFAULT:       [[SCALAR_PH]]:
; DEFAULT-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; DEFAULT-NEXT:    br label %[[LOOP_HEADER:.*]]
; DEFAULT:       [[LOOP_HEADER]]:
; DEFAULT-NEXT:    [[IV175:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT176:%.*]], %[[LOOP_LATCH:.*]] ]
; DEFAULT-NEXT:    [[ARRAYIDX114:%.*]] = getelementptr double, ptr [[SRC]], i64 [[IV175]]
; DEFAULT-NEXT:    [[TMP16:%.*]] = load double, ptr [[ARRAYIDX114]], align 8
; DEFAULT-NEXT:    [[TMP17:%.*]] = tail call double @llvm.fabs.f64(double [[TMP16]])
; DEFAULT-NEXT:    [[CMP115:%.*]] = fcmp ogt double [[TMP17]], 1.000000e+00
; DEFAULT-NEXT:    br i1 [[CMP115]], label %[[THEN:.*]], label %[[LOOP_LATCH]]
; DEFAULT:       [[THEN]]:
; DEFAULT-NEXT:    store i32 0, ptr [[DST]], align 4
; DEFAULT-NEXT:    br label %[[LOOP_LATCH]]
; DEFAULT:       [[LOOP_LATCH]]:
; DEFAULT-NEXT:    [[IV_NEXT176]] = add i64 [[IV175]], 1
; DEFAULT-NEXT:    [[EXITCOND180_NOT:%.*]] = icmp eq i64 [[IV175]], [[N]]
; DEFAULT-NEXT:    br i1 [[EXITCOND180_NOT]], label %[[EXIT]], label %[[LOOP_HEADER]], !llvm.loop [[LOOP3:![0-9]+]]
; DEFAULT:       [[EXIT]]:
; DEFAULT-NEXT:    ret void
;
; PRED-LABEL: define void @loop_dependent_cond(
; PRED-SAME: ptr [[SRC:%.*]], ptr noalias [[DST:%.*]], i64 [[N:%.*]]) {
; PRED-NEXT:  [[ENTRY:.*]]:
; PRED-NEXT:    br label %[[LOOP_HEADER:.*]]
; PRED:       [[LOOP_HEADER]]:
; PRED-NEXT:    [[IV175:%.*]] = phi i64 [ 0, %[[ENTRY]] ], [ [[IV_NEXT176:%.*]], %[[LOOP_LATCH:.*]] ]
; PRED-NEXT:    [[ARRAYIDX114:%.*]] = getelementptr double, ptr [[SRC]], i64 [[IV175]]
; PRED-NEXT:    [[TMP0:%.*]] = load double, ptr [[ARRAYIDX114]], align 8
; PRED-NEXT:    [[TMP1:%.*]] = tail call double @llvm.fabs.f64(double [[TMP0]])
; PRED-NEXT:    [[CMP115:%.*]] = fcmp ogt double [[TMP1]], 1.000000e+00
; PRED-NEXT:    br i1 [[CMP115]], label %[[THEN:.*]], label %[[LOOP_LATCH]]
; PRED:       [[THEN]]:
; PRED-NEXT:    store i32 0, ptr [[DST]], align 4
; PRED-NEXT:    br label %[[LOOP_LATCH]]
; PRED:       [[LOOP_LATCH]]:
; PRED-NEXT:    [[IV_NEXT176]] = add i64 [[IV175]], 1
; PRED-NEXT:    [[EXITCOND180_NOT:%.*]] = icmp eq i64 [[IV175]], [[N]]
; PRED-NEXT:    br i1 [[EXITCOND180_NOT]], label %[[EXIT:.*]], label %[[LOOP_HEADER]]
; PRED:       [[EXIT]]:
; PRED-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %gep = getelementptr double, ptr %src, i64 %iv
  %l = load double, ptr %gep, align 8
  %abs = tail call double @llvm.fabs.f64(double %l)
  %cmp = fcmp ogt double %abs, 1.000000e+00
  br i1 %cmp, label %then, label %loop.latch

then:
  store i32 0, ptr %dst, align 4
  br label %loop.latch

loop.latch:
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %N
  br i1 %ec, label %exit, label %loop.header

exit:
  ret void
}

define void @invar_cond_chain_1(ptr %I, ptr noalias %src, i1 %c) {
; DEFAULT-LABEL: define void @invar_cond_chain_1(
; DEFAULT-SAME: ptr [[I:%.*]], ptr noalias [[SRC:%.*]], i1 [[C:%.*]]) {
; DEFAULT-NEXT:  [[ENTRY:.*]]:
; DEFAULT-NEXT:    br label %[[LOOP_HEADER:.*]]
; DEFAULT:       [[LOOP_HEADER]]:
; DEFAULT-NEXT:    [[__BEGIN3_011973:%.*]] = phi ptr [ [[SRC]], %[[ENTRY]] ], [ [[INCDEC_PTR329:%.*]], %[[LOOP_LATCH:.*]] ]
; DEFAULT-NEXT:    [[TMP28:%.*]] = load i32, ptr [[__BEGIN3_011973]], align 4
; DEFAULT-NEXT:    br i1 true, label %[[ELSE_1:.*]], label %[[IF:.*]]
; DEFAULT:       [[IF]]:
; DEFAULT-NEXT:    br label %[[SPLIT:.*]]
; DEFAULT:       [[ELSE_1]]:
; DEFAULT-NEXT:    br i1 [[C]], label %[[ELSE_2:.*]], label %[[LOOP_LATCH]]
; DEFAULT:       [[ELSE_2]]:
; DEFAULT-NEXT:    br label %[[SPLIT]]
; DEFAULT:       [[SPLIT]]:
; DEFAULT-NEXT:    store i32 [[TMP28]], ptr [[I]], align 4
; DEFAULT-NEXT:    br label %[[LOOP_LATCH]]
; DEFAULT:       [[LOOP_LATCH]]:
; DEFAULT-NEXT:    [[INCDEC_PTR329]] = getelementptr inbounds i8, ptr [[__BEGIN3_011973]], i64 4
; DEFAULT-NEXT:    [[CMP311_NOT:%.*]] = icmp eq ptr [[__BEGIN3_011973]], [[I]]
; DEFAULT-NEXT:    br i1 [[CMP311_NOT]], label %[[EXIT:.*]], label %[[LOOP_HEADER]]
; DEFAULT:       [[EXIT]]:
; DEFAULT-NEXT:    ret void
;
; PRED-LABEL: define void @invar_cond_chain_1(
; PRED-SAME: ptr [[I:%.*]], ptr noalias [[SRC:%.*]], i1 [[C:%.*]]) {
; PRED-NEXT:  [[ENTRY:.*]]:
; PRED-NEXT:    br label %[[LOOP_HEADER:.*]]
; PRED:       [[LOOP_HEADER]]:
; PRED-NEXT:    [[__BEGIN3_011973:%.*]] = phi ptr [ [[SRC]], %[[ENTRY]] ], [ [[INCDEC_PTR329:%.*]], %[[LOOP_LATCH:.*]] ]
; PRED-NEXT:    [[TMP0:%.*]] = load i32, ptr [[__BEGIN3_011973]], align 4
; PRED-NEXT:    br i1 true, label %[[ELSE_1:.*]], label %[[IF:.*]]
; PRED:       [[IF]]:
; PRED-NEXT:    br label %[[SPLIT:.*]]
; PRED:       [[ELSE_1]]:
; PRED-NEXT:    br i1 [[C]], label %[[ELSE_2:.*]], label %[[LOOP_LATCH]]
; PRED:       [[ELSE_2]]:
; PRED-NEXT:    br label %[[SPLIT]]
; PRED:       [[SPLIT]]:
; PRED-NEXT:    store i32 [[TMP0]], ptr [[I]], align 4
; PRED-NEXT:    br label %[[LOOP_LATCH]]
; PRED:       [[LOOP_LATCH]]:
; PRED-NEXT:    [[INCDEC_PTR329]] = getelementptr inbounds i8, ptr [[__BEGIN3_011973]], i64 4
; PRED-NEXT:    [[CMP311_NOT:%.*]] = icmp eq ptr [[__BEGIN3_011973]], [[I]]
; PRED-NEXT:    br i1 [[CMP311_NOT]], label %[[EXIT:.*]], label %[[LOOP_HEADER]]
; PRED:       [[EXIT]]:
; PRED-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %src, %entry ], [ %ptr.iv.next, %loop.latch ]
  %l = load i32, ptr %ptr.iv, align 4
  br i1 true, label %else.1, label %if

if:
  br label %split

else.1:
  br i1 %c, label %else.2, label %loop.latch

else.2:
  br label %split

split:
  store i32 %l, ptr %I, align 4
  br label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds i8, ptr %ptr.iv, i64 4
  %ec = icmp eq ptr %ptr.iv, %I
  br i1 %ec, label %exit, label %loop.header

exit:
  ret void
}

define void @invar_cond_chain_2(ptr %I, ptr noalias %src, ptr noalias %dst, i32 %a) {
; DEFAULT-LABEL: define void @invar_cond_chain_2(
; DEFAULT-SAME: ptr [[I:%.*]], ptr noalias [[SRC:%.*]], ptr noalias [[DST:%.*]], i32 [[A:%.*]]) {
; DEFAULT-NEXT:  [[ENTRY:.*]]:
; DEFAULT-NEXT:    br label %[[LOOP_HEADER:.*]]
; DEFAULT:       [[LOOP_HEADER]]:
; DEFAULT-NEXT:    [[__BEGIN3_01197:%.*]] = phi ptr [ [[SRC]], %[[ENTRY]] ], [ [[INCDEC_PTR329:%.*]], %[[LOOP_LATCH:.*]] ]
; DEFAULT-NEXT:    [[CMP315_NOT:%.*]] = icmp sgt i32 [[A]], 0
; DEFAULT-NEXT:    br i1 [[CMP315_NOT]], label %[[LOOP_LATCH]], label %[[IF:.*]]
; DEFAULT:       [[IF]]:
; DEFAULT-NEXT:    br label %[[ELSE:.*]]
; DEFAULT:       [[ELSE]]:
; DEFAULT-NEXT:    store i32 0, ptr [[DST]], align 4
; DEFAULT-NEXT:    br label %[[LOOP_LATCH]]
; DEFAULT:       [[LOOP_LATCH]]:
; DEFAULT-NEXT:    [[INCDEC_PTR329]] = getelementptr inbounds i8, ptr [[__BEGIN3_01197]], i64 4
; DEFAULT-NEXT:    [[CMP311_NOT:%.*]] = icmp eq ptr [[__BEGIN3_01197]], [[I]]
; DEFAULT-NEXT:    br i1 [[CMP311_NOT]], label %[[EXIT:.*]], label %[[LOOP_HEADER]]
; DEFAULT:       [[EXIT]]:
; DEFAULT-NEXT:    ret void
;
; PRED-LABEL: define void @invar_cond_chain_2(
; PRED-SAME: ptr [[I:%.*]], ptr noalias [[SRC:%.*]], ptr noalias [[DST:%.*]], i32 [[A:%.*]]) {
; PRED-NEXT:  [[ENTRY:.*]]:
; PRED-NEXT:    br label %[[LOOP_HEADER:.*]]
; PRED:       [[LOOP_HEADER]]:
; PRED-NEXT:    [[__BEGIN3_01197:%.*]] = phi ptr [ [[SRC]], %[[ENTRY]] ], [ [[INCDEC_PTR329:%.*]], %[[LOOP_LATCH:.*]] ]
; PRED-NEXT:    [[CMP315_NOT:%.*]] = icmp sgt i32 [[A]], 0
; PRED-NEXT:    br i1 [[CMP315_NOT]], label %[[LOOP_LATCH]], label %[[IF:.*]]
; PRED:       [[IF]]:
; PRED-NEXT:    br label %[[ELSE:.*]]
; PRED:       [[ELSE]]:
; PRED-NEXT:    store i32 0, ptr [[DST]], align 4
; PRED-NEXT:    br label %[[LOOP_LATCH]]
; PRED:       [[LOOP_LATCH]]:
; PRED-NEXT:    [[INCDEC_PTR329]] = getelementptr inbounds i8, ptr [[__BEGIN3_01197]], i64 4
; PRED-NEXT:    [[CMP311_NOT:%.*]] = icmp eq ptr [[__BEGIN3_01197]], [[I]]
; PRED-NEXT:    br i1 [[CMP311_NOT]], label %[[EXIT:.*]], label %[[LOOP_HEADER]]
; PRED:       [[EXIT]]:
; PRED-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %src, %entry ], [ %ptr.iv.next, %loop.latch ]
  %cmp315.not = icmp sgt i32 %a, 0
  br i1 %cmp315.not, label %loop.latch, label %if

if:
  br label %else

else:
  store i32 0, ptr %dst, align 4
  br label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds i8, ptr %ptr.iv, i64 4
  %cmp311.not = icmp eq ptr %ptr.iv, %I
  br i1 %cmp311.not, label %exit, label %loop.header

exit:
  ret void
}

define void @latch_branch_cost(ptr %dst) {
; DEFAULT-LABEL: define void @latch_branch_cost(
; DEFAULT-SAME: ptr [[DST:%.*]]) {
; DEFAULT-NEXT:  [[ITER_CHECK:.*]]:
; DEFAULT-NEXT:    br i1 false, label %[[VEC_EPILOG_SCALAR_PH:.*]], label %[[VECTOR_MAIN_LOOP_ITER_CHECK:.*]]
; DEFAULT:       [[VECTOR_MAIN_LOOP_ITER_CHECK]]:
; DEFAULT-NEXT:    br i1 false, label %[[VEC_EPILOG_PH:.*]], label %[[VECTOR_PH:.*]]
; DEFAULT:       [[VECTOR_PH]]:
; DEFAULT-NEXT:    br label %[[VECTOR_BODY:.*]]
; DEFAULT:       [[VECTOR_BODY]]:
; DEFAULT-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; DEFAULT-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[DST]], i64 [[INDEX]]
; DEFAULT-NEXT:    [[TMP6:%.*]] = getelementptr i8, ptr [[TMP2]], i32 0
; DEFAULT-NEXT:    [[TMP5:%.*]] = getelementptr i8, ptr [[TMP2]], i32 16
; DEFAULT-NEXT:    store <16 x i8> zeroinitializer, ptr [[TMP6]], align 1
; DEFAULT-NEXT:    store <16 x i8> zeroinitializer, ptr [[TMP5]], align 1
; DEFAULT-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 32
; DEFAULT-NEXT:    [[TMP4:%.*]] = icmp eq i64 [[INDEX_NEXT]], 96
; DEFAULT-NEXT:    br i1 [[TMP4]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP4:![0-9]+]]
; DEFAULT:       [[MIDDLE_BLOCK]]:
; DEFAULT-NEXT:    br i1 false, label %[[EXIT:.*]], label %[[VEC_EPILOG_ITER_CHECK:.*]]
; DEFAULT:       [[VEC_EPILOG_ITER_CHECK]]:
; DEFAULT-NEXT:    br i1 false, label %[[VEC_EPILOG_SCALAR_PH]], label %[[VEC_EPILOG_PH]]
; DEFAULT:       [[VEC_EPILOG_PH]]:
; DEFAULT-NEXT:    [[VEC_EPILOG_RESUME_VAL:%.*]] = phi i64 [ 96, %[[VEC_EPILOG_ITER_CHECK]] ], [ 0, %[[VECTOR_MAIN_LOOP_ITER_CHECK]] ]
; DEFAULT-NEXT:    br label %[[VEC_EPILOG_VECTOR_BODY:.*]]
; DEFAULT:       [[VEC_EPILOG_VECTOR_BODY]]:
; DEFAULT-NEXT:    [[INDEX1:%.*]] = phi i64 [ [[VEC_EPILOG_RESUME_VAL]], %[[VEC_EPILOG_PH]] ], [ [[INDEX_NEXT2:%.*]], %[[VEC_EPILOG_VECTOR_BODY]] ]
; DEFAULT-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[DST]], i64 [[INDEX1]]
; DEFAULT-NEXT:    [[TMP9:%.*]] = getelementptr i8, ptr [[TMP8]], i32 0
; DEFAULT-NEXT:    store <4 x i8> zeroinitializer, ptr [[TMP9]], align 1
; DEFAULT-NEXT:    [[INDEX_NEXT2]] = add nuw i64 [[INDEX1]], 4
; DEFAULT-NEXT:    [[TMP10:%.*]] = icmp eq i64 [[INDEX_NEXT2]], 100
; DEFAULT-NEXT:    br i1 [[TMP10]], label %[[VEC_EPILOG_MIDDLE_BLOCK:.*]], label %[[VEC_EPILOG_VECTOR_BODY]], !llvm.loop [[LOOP5:![0-9]+]]
; DEFAULT:       [[VEC_EPILOG_MIDDLE_BLOCK]]:
; DEFAULT-NEXT:    br i1 true, label %[[EXIT]], label %[[VEC_EPILOG_SCALAR_PH]]
; DEFAULT:       [[VEC_EPILOG_SCALAR_PH]]:
; DEFAULT-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 100, %[[VEC_EPILOG_MIDDLE_BLOCK]] ], [ 96, %[[VEC_EPILOG_ITER_CHECK]] ], [ 0, %[[ITER_CHECK]] ]
; DEFAULT-NEXT:    br label %[[LOOP:.*]]
; DEFAULT:       [[LOOP]]:
; DEFAULT-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[VEC_EPILOG_SCALAR_PH]] ], [ [[INDVARS_IV_NEXT:%.*]], %[[LOOP]] ]
; DEFAULT-NEXT:    [[ARRAYIDX:%.*]] = getelementptr i8, ptr [[DST]], i64 [[INDVARS_IV]]
; DEFAULT-NEXT:    store i8 0, ptr [[ARRAYIDX]], align 1
; DEFAULT-NEXT:    [[INDVARS_IV_NEXT]] = add i64 [[INDVARS_IV]], 1
; DEFAULT-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], 100
; DEFAULT-NEXT:    br i1 [[EXITCOND_NOT]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP6:![0-9]+]]
; DEFAULT:       [[EXIT]]:
; DEFAULT-NEXT:    ret void
;
; PRED-LABEL: define void @latch_branch_cost(
; PRED-SAME: ptr [[DST:%.*]]) {
; PRED-NEXT:  [[ENTRY:.*]]:
; PRED-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; PRED:       [[VECTOR_PH]]:
; PRED-NEXT:    br label %[[VECTOR_BODY:.*]]
; PRED:       [[VECTOR_BODY]]:
; PRED-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[PRED_STORE_CONTINUE14:.*]] ]
; PRED-NEXT:    [[VEC_IND:%.*]] = phi <8 x i8> [ <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[PRED_STORE_CONTINUE14]] ]
; PRED-NEXT:    [[TMP0:%.*]] = icmp ule <8 x i8> [[VEC_IND]], splat (i8 99)
; PRED-NEXT:    [[TMP1:%.*]] = extractelement <8 x i1> [[TMP0]], i32 0
; PRED-NEXT:    br i1 [[TMP1]], label %[[PRED_STORE_IF:.*]], label %[[PRED_STORE_CONTINUE:.*]]
; PRED:       [[PRED_STORE_IF]]:
; PRED-NEXT:    [[TMP2:%.*]] = add i64 [[INDEX]], 0
; PRED-NEXT:    [[TMP3:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP2]]
; PRED-NEXT:    store i8 0, ptr [[TMP3]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE]]
; PRED:       [[PRED_STORE_CONTINUE]]:
; PRED-NEXT:    [[TMP4:%.*]] = extractelement <8 x i1> [[TMP0]], i32 1
; PRED-NEXT:    br i1 [[TMP4]], label %[[PRED_STORE_IF1:.*]], label %[[PRED_STORE_CONTINUE2:.*]]
; PRED:       [[PRED_STORE_IF1]]:
; PRED-NEXT:    [[TMP5:%.*]] = add i64 [[INDEX]], 1
; PRED-NEXT:    [[TMP6:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP5]]
; PRED-NEXT:    store i8 0, ptr [[TMP6]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE2]]
; PRED:       [[PRED_STORE_CONTINUE2]]:
; PRED-NEXT:    [[TMP7:%.*]] = extractelement <8 x i1> [[TMP0]], i32 2
; PRED-NEXT:    br i1 [[TMP7]], label %[[PRED_STORE_IF3:.*]], label %[[PRED_STORE_CONTINUE4:.*]]
; PRED:       [[PRED_STORE_IF3]]:
; PRED-NEXT:    [[TMP8:%.*]] = add i64 [[INDEX]], 2
; PRED-NEXT:    [[TMP9:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP8]]
; PRED-NEXT:    store i8 0, ptr [[TMP9]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE4]]
; PRED:       [[PRED_STORE_CONTINUE4]]:
; PRED-NEXT:    [[TMP10:%.*]] = extractelement <8 x i1> [[TMP0]], i32 3
; PRED-NEXT:    br i1 [[TMP10]], label %[[PRED_STORE_IF5:.*]], label %[[PRED_STORE_CONTINUE6:.*]]
; PRED:       [[PRED_STORE_IF5]]:
; PRED-NEXT:    [[TMP11:%.*]] = add i64 [[INDEX]], 3
; PRED-NEXT:    [[TMP12:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP11]]
; PRED-NEXT:    store i8 0, ptr [[TMP12]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE6]]
; PRED:       [[PRED_STORE_CONTINUE6]]:
; PRED-NEXT:    [[TMP13:%.*]] = extractelement <8 x i1> [[TMP0]], i32 4
; PRED-NEXT:    br i1 [[TMP13]], label %[[PRED_STORE_IF7:.*]], label %[[PRED_STORE_CONTINUE8:.*]]
; PRED:       [[PRED_STORE_IF7]]:
; PRED-NEXT:    [[TMP14:%.*]] = add i64 [[INDEX]], 4
; PRED-NEXT:    [[TMP15:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP14]]
; PRED-NEXT:    store i8 0, ptr [[TMP15]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE8]]
; PRED:       [[PRED_STORE_CONTINUE8]]:
; PRED-NEXT:    [[TMP16:%.*]] = extractelement <8 x i1> [[TMP0]], i32 5
; PRED-NEXT:    br i1 [[TMP16]], label %[[PRED_STORE_IF9:.*]], label %[[PRED_STORE_CONTINUE10:.*]]
; PRED:       [[PRED_STORE_IF9]]:
; PRED-NEXT:    [[TMP17:%.*]] = add i64 [[INDEX]], 5
; PRED-NEXT:    [[TMP18:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP17]]
; PRED-NEXT:    store i8 0, ptr [[TMP18]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE10]]
; PRED:       [[PRED_STORE_CONTINUE10]]:
; PRED-NEXT:    [[TMP19:%.*]] = extractelement <8 x i1> [[TMP0]], i32 6
; PRED-NEXT:    br i1 [[TMP19]], label %[[PRED_STORE_IF11:.*]], label %[[PRED_STORE_CONTINUE12:.*]]
; PRED:       [[PRED_STORE_IF11]]:
; PRED-NEXT:    [[TMP20:%.*]] = add i64 [[INDEX]], 6
; PRED-NEXT:    [[TMP21:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP20]]
; PRED-NEXT:    store i8 0, ptr [[TMP21]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE12]]
; PRED:       [[PRED_STORE_CONTINUE12]]:
; PRED-NEXT:    [[TMP22:%.*]] = extractelement <8 x i1> [[TMP0]], i32 7
; PRED-NEXT:    br i1 [[TMP22]], label %[[PRED_STORE_IF13:.*]], label %[[PRED_STORE_CONTINUE14]]
; PRED:       [[PRED_STORE_IF13]]:
; PRED-NEXT:    [[TMP23:%.*]] = add i64 [[INDEX]], 7
; PRED-NEXT:    [[TMP24:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP23]]
; PRED-NEXT:    store i8 0, ptr [[TMP24]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE14]]
; PRED:       [[PRED_STORE_CONTINUE14]]:
; PRED-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 8
; PRED-NEXT:    [[VEC_IND_NEXT]] = add <8 x i8> [[VEC_IND]], splat (i8 8)
; PRED-NEXT:    [[TMP25:%.*]] = icmp eq i64 [[INDEX_NEXT]], 104
; PRED-NEXT:    br i1 [[TMP25]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; PRED:       [[MIDDLE_BLOCK]]:
; PRED-NEXT:    br label %[[EXIT:.*]]
; PRED:       [[SCALAR_PH]]:
; PRED-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 0, %[[ENTRY]] ]
; PRED-NEXT:    br label %[[LOOP:.*]]
; PRED:       [[LOOP]]:
; PRED-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; PRED-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[DST]], i64 [[IV]]
; PRED-NEXT:    store i8 0, ptr [[GEP]], align 1
; PRED-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; PRED-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], 100
; PRED-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP3:![0-9]+]]
; PRED:       [[EXIT]]:
; PRED-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %gep = getelementptr i8, ptr %dst, i64 %iv
  store i8 0, ptr %gep, align 1
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv.next, 100
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define i32 @header_mask_and_invariant_compare(ptr %A, ptr %B, ptr %C, ptr %D, ptr %E, i64 %N) "target-features"="+sve" {
; DEFAULT-LABEL: define i32 @header_mask_and_invariant_compare(
; DEFAULT-SAME: ptr [[A:%.*]], ptr [[B:%.*]], ptr [[C:%.*]], ptr [[D:%.*]], ptr [[E:%.*]], i64 [[N:%.*]]) #[[ATTR1:[0-9]+]] {
; DEFAULT-NEXT:  [[ENTRY:.*]]:
; DEFAULT-NEXT:    [[TMP0:%.*]] = add i64 [[N]], 1
; DEFAULT-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[TMP0]], 60
; DEFAULT-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_MEMCHECK:.*]]
; DEFAULT:       [[VECTOR_MEMCHECK]]:
; DEFAULT-NEXT:    [[SCEVGEP:%.*]] = getelementptr i8, ptr [[E]], i64 4
; DEFAULT-NEXT:    [[TMP1:%.*]] = shl i64 [[N]], 2
; DEFAULT-NEXT:    [[TMP2:%.*]] = add i64 [[TMP1]], 4
; DEFAULT-NEXT:    [[SCEVGEP1:%.*]] = getelementptr i8, ptr [[D]], i64 [[TMP2]]
; DEFAULT-NEXT:    [[SCEVGEP2:%.*]] = getelementptr i8, ptr [[A]], i64 4
; DEFAULT-NEXT:    [[SCEVGEP3:%.*]] = getelementptr i8, ptr [[B]], i64 4
; DEFAULT-NEXT:    [[SCEVGEP4:%.*]] = getelementptr i8, ptr [[C]], i64 4
; DEFAULT-NEXT:    [[BOUND0:%.*]] = icmp ult ptr [[E]], [[SCEVGEP1]]
; DEFAULT-NEXT:    [[BOUND1:%.*]] = icmp ult ptr [[D]], [[SCEVGEP]]
; DEFAULT-NEXT:    [[FOUND_CONFLICT:%.*]] = and i1 [[BOUND0]], [[BOUND1]]
; DEFAULT-NEXT:    [[BOUND05:%.*]] = icmp ult ptr [[E]], [[SCEVGEP2]]
; DEFAULT-NEXT:    [[BOUND16:%.*]] = icmp ult ptr [[A]], [[SCEVGEP]]
; DEFAULT-NEXT:    [[FOUND_CONFLICT7:%.*]] = and i1 [[BOUND05]], [[BOUND16]]
; DEFAULT-NEXT:    [[CONFLICT_RDX:%.*]] = or i1 [[FOUND_CONFLICT]], [[FOUND_CONFLICT7]]
; DEFAULT-NEXT:    [[BOUND08:%.*]] = icmp ult ptr [[E]], [[SCEVGEP3]]
; DEFAULT-NEXT:    [[BOUND19:%.*]] = icmp ult ptr [[B]], [[SCEVGEP]]
; DEFAULT-NEXT:    [[FOUND_CONFLICT10:%.*]] = and i1 [[BOUND08]], [[BOUND19]]
; DEFAULT-NEXT:    [[CONFLICT_RDX11:%.*]] = or i1 [[CONFLICT_RDX]], [[FOUND_CONFLICT10]]
; DEFAULT-NEXT:    [[BOUND012:%.*]] = icmp ult ptr [[E]], [[SCEVGEP4]]
; DEFAULT-NEXT:    [[BOUND113:%.*]] = icmp ult ptr [[C]], [[SCEVGEP]]
; DEFAULT-NEXT:    [[FOUND_CONFLICT14:%.*]] = and i1 [[BOUND012]], [[BOUND113]]
; DEFAULT-NEXT:    [[CONFLICT_RDX15:%.*]] = or i1 [[CONFLICT_RDX11]], [[FOUND_CONFLICT14]]
; DEFAULT-NEXT:    [[BOUND016:%.*]] = icmp ult ptr [[D]], [[SCEVGEP2]]
; DEFAULT-NEXT:    [[BOUND117:%.*]] = icmp ult ptr [[A]], [[SCEVGEP1]]
; DEFAULT-NEXT:    [[FOUND_CONFLICT18:%.*]] = and i1 [[BOUND016]], [[BOUND117]]
; DEFAULT-NEXT:    [[CONFLICT_RDX19:%.*]] = or i1 [[CONFLICT_RDX15]], [[FOUND_CONFLICT18]]
; DEFAULT-NEXT:    [[BOUND020:%.*]] = icmp ult ptr [[D]], [[SCEVGEP3]]
; DEFAULT-NEXT:    [[BOUND121:%.*]] = icmp ult ptr [[B]], [[SCEVGEP1]]
; DEFAULT-NEXT:    [[FOUND_CONFLICT22:%.*]] = and i1 [[BOUND020]], [[BOUND121]]
; DEFAULT-NEXT:    [[CONFLICT_RDX23:%.*]] = or i1 [[CONFLICT_RDX19]], [[FOUND_CONFLICT22]]
; DEFAULT-NEXT:    [[BOUND024:%.*]] = icmp ult ptr [[D]], [[SCEVGEP4]]
; DEFAULT-NEXT:    [[BOUND125:%.*]] = icmp ult ptr [[C]], [[SCEVGEP1]]
; DEFAULT-NEXT:    [[FOUND_CONFLICT26:%.*]] = and i1 [[BOUND024]], [[BOUND125]]
; DEFAULT-NEXT:    [[CONFLICT_RDX27:%.*]] = or i1 [[CONFLICT_RDX23]], [[FOUND_CONFLICT26]]
; DEFAULT-NEXT:    br i1 [[CONFLICT_RDX27]], label %[[SCALAR_PH]], label %[[VECTOR_PH:.*]]
; DEFAULT:       [[VECTOR_PH]]:
; DEFAULT-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[TMP0]], 4
; DEFAULT-NEXT:    [[N_VEC:%.*]] = sub i64 [[TMP0]], [[N_MOD_VF]]
; DEFAULT-NEXT:    br label %[[VECTOR_BODY:.*]]
; DEFAULT:       [[VECTOR_BODY]]:
; DEFAULT-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[PRED_STORE_CONTINUE37:.*]] ]
; DEFAULT-NEXT:    [[TMP9:%.*]] = load i32, ptr [[A]], align 4, !alias.scope [[META7:![0-9]+]]
; DEFAULT-NEXT:    [[BROADCAST_SPLATINSERT28:%.*]] = insertelement <4 x i32> poison, i32 [[TMP9]], i64 0
; DEFAULT-NEXT:    [[BROADCAST_SPLAT29:%.*]] = shufflevector <4 x i32> [[BROADCAST_SPLATINSERT28]], <4 x i32> poison, <4 x i32> zeroinitializer
; DEFAULT-NEXT:    [[TMP19:%.*]] = load i32, ptr [[B]], align 4, !alias.scope [[META10:![0-9]+]]
; DEFAULT-NEXT:    [[BROADCAST_SPLATINSERT:%.*]] = insertelement <4 x i32> poison, i32 [[TMP19]], i64 0
; DEFAULT-NEXT:    [[BROADCAST_SPLAT:%.*]] = shufflevector <4 x i32> [[BROADCAST_SPLATINSERT]], <4 x i32> poison, <4 x i32> zeroinitializer
; DEFAULT-NEXT:    [[TMP6:%.*]] = or <4 x i32> [[BROADCAST_SPLAT]], [[BROADCAST_SPLAT29]]
; DEFAULT-NEXT:    [[TMP7:%.*]] = load i32, ptr [[C]], align 4, !alias.scope [[META12:![0-9]+]]
; DEFAULT-NEXT:    [[BROADCAST_SPLATINSERT30:%.*]] = insertelement <4 x i32> poison, i32 [[TMP7]], i64 0
; DEFAULT-NEXT:    [[BROADCAST_SPLAT31:%.*]] = shufflevector <4 x i32> [[BROADCAST_SPLATINSERT30]], <4 x i32> poison, <4 x i32> zeroinitializer
; DEFAULT-NEXT:    [[TMP8:%.*]] = icmp ugt <4 x i32> [[BROADCAST_SPLAT31]], [[TMP6]]
; DEFAULT-NEXT:    [[TMP16:%.*]] = getelementptr i32, ptr [[D]], i64 [[INDEX]]
; DEFAULT-NEXT:    [[TMP20:%.*]] = extractelement <4 x i1> [[TMP8]], i32 0
; DEFAULT-NEXT:    br i1 [[TMP20]], label %[[PRED_STORE_IF:.*]], label %[[PRED_STORE_CONTINUE:.*]]
; DEFAULT:       [[PRED_STORE_IF]]:
; DEFAULT-NEXT:    [[TMP11:%.*]] = extractelement <4 x i32> [[TMP6]], i32 0
; DEFAULT-NEXT:    store i32 [[TMP11]], ptr [[E]], align 4, !alias.scope [[META14:![0-9]+]], !noalias [[META16:![0-9]+]]
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE]]
; DEFAULT:       [[PRED_STORE_CONTINUE]]:
; DEFAULT-NEXT:    [[TMP12:%.*]] = extractelement <4 x i1> [[TMP8]], i32 1
; DEFAULT-NEXT:    br i1 [[TMP12]], label %[[PRED_STORE_IF32:.*]], label %[[PRED_STORE_CONTINUE33:.*]]
; DEFAULT:       [[PRED_STORE_IF32]]:
; DEFAULT-NEXT:    [[TMP13:%.*]] = extractelement <4 x i32> [[TMP6]], i32 0
; DEFAULT-NEXT:    store i32 [[TMP13]], ptr [[E]], align 4, !alias.scope [[META14]], !noalias [[META16]]
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE33]]
; DEFAULT:       [[PRED_STORE_CONTINUE33]]:
; DEFAULT-NEXT:    [[TMP14:%.*]] = extractelement <4 x i1> [[TMP8]], i32 2
; DEFAULT-NEXT:    br i1 [[TMP14]], label %[[PRED_STORE_IF34:.*]], label %[[PRED_STORE_CONTINUE35:.*]]
; DEFAULT:       [[PRED_STORE_IF34]]:
; DEFAULT-NEXT:    [[TMP15:%.*]] = extractelement <4 x i32> [[TMP6]], i32 0
; DEFAULT-NEXT:    store i32 [[TMP15]], ptr [[E]], align 4, !alias.scope [[META14]], !noalias [[META16]]
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE35]]
; DEFAULT:       [[PRED_STORE_CONTINUE35]]:
; DEFAULT-NEXT:    [[TMP21:%.*]] = extractelement <4 x i1> [[TMP8]], i32 3
; DEFAULT-NEXT:    br i1 [[TMP21]], label %[[PRED_STORE_IF36:.*]], label %[[PRED_STORE_CONTINUE37]]
; DEFAULT:       [[PRED_STORE_IF36]]:
; DEFAULT-NEXT:    [[TMP22:%.*]] = extractelement <4 x i32> [[TMP6]], i32 0
; DEFAULT-NEXT:    store i32 [[TMP22]], ptr [[E]], align 4, !alias.scope [[META14]], !noalias [[META16]]
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE37]]
; DEFAULT:       [[PRED_STORE_CONTINUE37]]:
; DEFAULT-NEXT:    [[TMP17:%.*]] = getelementptr i32, ptr [[TMP16]], i32 0
; DEFAULT-NEXT:    call void @llvm.masked.store.v4i32.p0(<4 x i32> zeroinitializer, ptr [[TMP17]], i32 4, <4 x i1> [[TMP8]]), !alias.scope [[META18:![0-9]+]], !noalias [[META19:![0-9]+]]
; DEFAULT-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; DEFAULT-NEXT:    [[TMP18:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; DEFAULT-NEXT:    br i1 [[TMP18]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP20:![0-9]+]]
; DEFAULT:       [[MIDDLE_BLOCK]]:
; DEFAULT-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[TMP0]], [[N_VEC]]
; DEFAULT-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; DEFAULT:       [[SCALAR_PH]]:
; DEFAULT-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ], [ 0, %[[VECTOR_MEMCHECK]] ]
; DEFAULT-NEXT:    br label %[[LOOP_HEADER:.*]]
; DEFAULT:       [[LOOP_HEADER]]:
; DEFAULT-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; DEFAULT-NEXT:    [[L_A:%.*]] = load i32, ptr [[A]], align 4
; DEFAULT-NEXT:    [[L_B:%.*]] = load i32, ptr [[B]], align 4
; DEFAULT-NEXT:    [[OR:%.*]] = or i32 [[L_B]], [[L_A]]
; DEFAULT-NEXT:    [[L_C:%.*]] = load i32, ptr [[C]], align 4
; DEFAULT-NEXT:    [[C_0:%.*]] = icmp ugt i32 [[L_C]], [[OR]]
; DEFAULT-NEXT:    br i1 [[C_0]], label %[[IF_THEN:.*]], label %[[LOOP_LATCH]]
; DEFAULT:       [[IF_THEN]]:
; DEFAULT-NEXT:    [[GEP_D:%.*]] = getelementptr i32, ptr [[D]], i64 [[IV]]
; DEFAULT-NEXT:    store i32 [[OR]], ptr [[E]], align 4
; DEFAULT-NEXT:    store i32 0, ptr [[GEP_D]], align 4
; DEFAULT-NEXT:    br label %[[LOOP_LATCH]]
; DEFAULT:       [[LOOP_LATCH]]:
; DEFAULT-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; DEFAULT-NEXT:    [[C_1:%.*]] = icmp eq i64 [[IV]], [[N]]
; DEFAULT-NEXT:    br i1 [[C_1]], label %[[EXIT]], label %[[LOOP_HEADER]], !llvm.loop [[LOOP21:![0-9]+]]
; DEFAULT:       [[EXIT]]:
; DEFAULT-NEXT:    ret i32 0
;
; PRED-LABEL: define i32 @header_mask_and_invariant_compare(
; PRED-SAME: ptr [[A:%.*]], ptr [[B:%.*]], ptr [[C:%.*]], ptr [[D:%.*]], ptr [[E:%.*]], i64 [[N:%.*]]) #[[ATTR1:[0-9]+]] {
; PRED-NEXT:  [[ENTRY:.*]]:
; PRED-NEXT:    br label %[[LOOP_HEADER:.*]]
; PRED:       [[LOOP_HEADER]]:
; PRED-NEXT:    [[IV:%.*]] = phi i64 [ 0, %[[ENTRY]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; PRED-NEXT:    [[L_A:%.*]] = load i32, ptr [[A]], align 4
; PRED-NEXT:    [[L_B:%.*]] = load i32, ptr [[B]], align 4
; PRED-NEXT:    [[OR:%.*]] = or i32 [[L_B]], [[L_A]]
; PRED-NEXT:    [[L_C:%.*]] = load i32, ptr [[C]], align 4
; PRED-NEXT:    [[C_0:%.*]] = icmp ugt i32 [[L_C]], [[OR]]
; PRED-NEXT:    br i1 [[C_0]], label %[[IF_THEN:.*]], label %[[LOOP_LATCH]]
; PRED:       [[IF_THEN]]:
; PRED-NEXT:    [[GEP_D:%.*]] = getelementptr i32, ptr [[D]], i64 [[IV]]
; PRED-NEXT:    store i32 [[OR]], ptr [[E]], align 4
; PRED-NEXT:    store i32 0, ptr [[GEP_D]], align 4
; PRED-NEXT:    br label %[[LOOP_LATCH]]
; PRED:       [[LOOP_LATCH]]:
; PRED-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; PRED-NEXT:    [[C_1:%.*]] = icmp eq i64 [[IV]], [[N]]
; PRED-NEXT:    br i1 [[C_1]], label %[[EXIT:.*]], label %[[LOOP_HEADER]]
; PRED:       [[EXIT]]:
; PRED-NEXT:    ret i32 0
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %l.A = load i32, ptr %A, align 4
  %l.B = load i32, ptr %B, align 4
  %or = or i32 %l.B, %l.A
  %l.C = load i32, ptr %C, align 4
  %c.0 = icmp ugt i32 %l.C, %or
  br i1 %c.0, label %if.then, label %loop.latch

if.then:
  %gep.D = getelementptr i32, ptr %D, i64 %iv
  store i32 %or, ptr %E, align 4
  store i32 0, ptr %gep.D, align 4
  br label %loop.latch

loop.latch:
  %iv.next = add i64 %iv, 1
  %c.1 = icmp eq i64 %iv, %N
  br i1 %c.1, label %exit, label %loop.header

exit:
  ret i32 0
}

define void @multiple_exit_conditions(ptr %src, ptr noalias %dst) #1 {
; DEFAULT-LABEL: define void @multiple_exit_conditions(
; DEFAULT-SAME: ptr [[SRC:%.*]], ptr noalias [[DST:%.*]]) #[[ATTR2:[0-9]+]] {
; DEFAULT-NEXT:  [[ENTRY:.*]]:
; DEFAULT-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; DEFAULT:       [[VECTOR_PH]]:
; DEFAULT-NEXT:    [[IND_END:%.*]] = getelementptr i8, ptr [[DST]], i64 2048
; DEFAULT-NEXT:    br label %[[VECTOR_BODY:.*]]
; DEFAULT:       [[VECTOR_BODY]]:
; DEFAULT-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; DEFAULT-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 8
; DEFAULT-NEXT:    [[NEXT_GEP:%.*]] = getelementptr i8, ptr [[DST]], i64 [[OFFSET_IDX]]
; DEFAULT-NEXT:    [[TMP1:%.*]] = load i16, ptr [[SRC]], align 2
; DEFAULT-NEXT:    [[BROADCAST_SPLATINSERT:%.*]] = insertelement <8 x i16> poison, i16 [[TMP1]], i64 0
; DEFAULT-NEXT:    [[BROADCAST_SPLAT:%.*]] = shufflevector <8 x i16> [[BROADCAST_SPLATINSERT]], <8 x i16> poison, <8 x i32> zeroinitializer
; DEFAULT-NEXT:    [[TMP2:%.*]] = or <8 x i16> [[BROADCAST_SPLAT]], splat (i16 1)
; DEFAULT-NEXT:    [[TMP3:%.*]] = uitofp <8 x i16> [[TMP2]] to <8 x double>
; DEFAULT-NEXT:    [[TMP4:%.*]] = getelementptr double, ptr [[NEXT_GEP]], i32 0
; DEFAULT-NEXT:    store <8 x double> [[TMP3]], ptr [[TMP4]], align 8
; DEFAULT-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 8
; DEFAULT-NEXT:    [[TMP5:%.*]] = icmp eq i64 [[INDEX_NEXT]], 256
; DEFAULT-NEXT:    br i1 [[TMP5]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP22:![0-9]+]]
; DEFAULT:       [[MIDDLE_BLOCK]]:
; DEFAULT-NEXT:    br i1 false, label %[[EXIT:.*]], label %[[SCALAR_PH]]
; DEFAULT:       [[SCALAR_PH]]:
; DEFAULT-NEXT:    [[BC_RESUME_VAL:%.*]] = phi ptr [ [[IND_END]], %[[MIDDLE_BLOCK]] ], [ [[DST]], %[[ENTRY]] ]
; DEFAULT-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 512, %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; DEFAULT-NEXT:    br label %[[LOOP:.*]]
; DEFAULT:       [[LOOP]]:
; DEFAULT-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[PTR_IV_NEXT:%.*]], %[[LOOP]] ]
; DEFAULT-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; DEFAULT-NEXT:    [[L:%.*]] = load i16, ptr [[SRC]], align 2
; DEFAULT-NEXT:    [[O:%.*]] = or i16 [[L]], 1
; DEFAULT-NEXT:    [[CONV:%.*]] = uitofp i16 [[O]] to double
; DEFAULT-NEXT:    store double [[CONV]], ptr [[PTR_IV]], align 8
; DEFAULT-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 2
; DEFAULT-NEXT:    [[PTR_IV_NEXT]] = getelementptr i8, ptr [[PTR_IV]], i64 8
; DEFAULT-NEXT:    [[IV_CLAMP:%.*]] = and i64 [[IV]], 4294967294
; DEFAULT-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_CLAMP]], 512
; DEFAULT-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP23:![0-9]+]]
; DEFAULT:       [[EXIT]]:
; DEFAULT-NEXT:    ret void
;
; PRED-LABEL: define void @multiple_exit_conditions(
; PRED-SAME: ptr [[SRC:%.*]], ptr noalias [[DST:%.*]]) #[[ATTR2:[0-9]+]] {
; PRED-NEXT:  [[ENTRY:.*]]:
; PRED-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; PRED:       [[VECTOR_PH]]:
; PRED-NEXT:    [[TMP0:%.*]] = call i64 @llvm.vscale.i64()
; PRED-NEXT:    [[TMP1:%.*]] = mul nuw i64 [[TMP0]], 2
; PRED-NEXT:    [[TMP2:%.*]] = sub i64 [[TMP1]], 1
; PRED-NEXT:    [[N_RND_UP:%.*]] = add i64 257, [[TMP2]]
; PRED-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N_RND_UP]], [[TMP1]]
; PRED-NEXT:    [[N_VEC:%.*]] = sub i64 [[N_RND_UP]], [[N_MOD_VF]]
; PRED-NEXT:    [[TMP4:%.*]] = call i64 @llvm.vscale.i64()
; PRED-NEXT:    [[TMP5:%.*]] = mul nuw i64 [[TMP4]], 2
; PRED-NEXT:    [[TMP6:%.*]] = call i64 @llvm.vscale.i64()
; PRED-NEXT:    [[TMP7:%.*]] = mul nuw i64 [[TMP6]], 2
; PRED-NEXT:    [[TMP8:%.*]] = sub i64 257, [[TMP7]]
; PRED-NEXT:    [[TMP9:%.*]] = icmp ugt i64 257, [[TMP7]]
; PRED-NEXT:    [[TMP10:%.*]] = select i1 [[TMP9]], i64 [[TMP8]], i64 0
; PRED-NEXT:    [[ACTIVE_LANE_MASK_ENTRY:%.*]] = call <vscale x 2 x i1> @llvm.get.active.lane.mask.nxv2i1.i64(i64 0, i64 257)
; PRED-NEXT:    br label %[[VECTOR_BODY:.*]]
; PRED:       [[VECTOR_BODY]]:
; PRED-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; PRED-NEXT:    [[ACTIVE_LANE_MASK:%.*]] = phi <vscale x 2 x i1> [ [[ACTIVE_LANE_MASK_ENTRY]], %[[VECTOR_PH]] ], [ [[ACTIVE_LANE_MASK_NEXT:%.*]], %[[VECTOR_BODY]] ]
; PRED-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 8
; PRED-NEXT:    [[NEXT_GEP:%.*]] = getelementptr i8, ptr [[DST]], i64 [[OFFSET_IDX]]
; PRED-NEXT:    [[TMP12:%.*]] = load i16, ptr [[SRC]], align 2
; PRED-NEXT:    [[BROADCAST_SPLATINSERT:%.*]] = insertelement <vscale x 2 x i16> poison, i16 [[TMP12]], i64 0
; PRED-NEXT:    [[BROADCAST_SPLAT:%.*]] = shufflevector <vscale x 2 x i16> [[BROADCAST_SPLATINSERT]], <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
; PRED-NEXT:    [[TMP13:%.*]] = or <vscale x 2 x i16> [[BROADCAST_SPLAT]], splat (i16 1)
; PRED-NEXT:    [[TMP14:%.*]] = uitofp <vscale x 2 x i16> [[TMP13]] to <vscale x 2 x double>
; PRED-NEXT:    [[TMP15:%.*]] = getelementptr double, ptr [[NEXT_GEP]], i32 0
; PRED-NEXT:    call void @llvm.masked.store.nxv2f64.p0(<vscale x 2 x double> [[TMP14]], ptr [[TMP15]], i32 8, <vscale x 2 x i1> [[ACTIVE_LANE_MASK]])
; PRED-NEXT:    [[INDEX_NEXT]] = add i64 [[INDEX]], [[TMP5]]
; PRED-NEXT:    [[ACTIVE_LANE_MASK_NEXT]] = call <vscale x 2 x i1> @llvm.get.active.lane.mask.nxv2i1.i64(i64 [[INDEX]], i64 [[TMP10]])
; PRED-NEXT:    [[TMP16:%.*]] = xor <vscale x 2 x i1> [[ACTIVE_LANE_MASK_NEXT]], splat (i1 true)
; PRED-NEXT:    [[TMP17:%.*]] = extractelement <vscale x 2 x i1> [[TMP16]], i32 0
; PRED-NEXT:    br i1 [[TMP17]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP4:![0-9]+]]
; PRED:       [[MIDDLE_BLOCK]]:
; PRED-NEXT:    br label %[[EXIT:.*]]
; PRED:       [[SCALAR_PH]]:
; PRED-NEXT:    [[BC_RESUME_VAL:%.*]] = phi ptr [ [[DST]], %[[ENTRY]] ]
; PRED-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 0, %[[ENTRY]] ]
; PRED-NEXT:    br label %[[LOOP:.*]]
; PRED:       [[LOOP]]:
; PRED-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[PTR_IV_NEXT:%.*]], %[[LOOP]] ]
; PRED-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; PRED-NEXT:    [[L:%.*]] = load i16, ptr [[SRC]], align 2
; PRED-NEXT:    [[O:%.*]] = or i16 [[L]], 1
; PRED-NEXT:    [[CONV:%.*]] = uitofp i16 [[O]] to double
; PRED-NEXT:    store double [[CONV]], ptr [[PTR_IV]], align 8
; PRED-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 2
; PRED-NEXT:    [[PTR_IV_NEXT]] = getelementptr i8, ptr [[PTR_IV]], i64 8
; PRED-NEXT:    [[IV_CLAMP:%.*]] = and i64 [[IV]], 4294967294
; PRED-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_CLAMP]], 512
; PRED-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP5:![0-9]+]]
; PRED:       [[EXIT]]:
; PRED-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %ptr.iv = phi ptr [ %dst, %entry ], [ %ptr.iv.next, %loop ]
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %l = load i16, ptr %src, align 2
  %o = or i16 %l, 1
  %conv = uitofp i16 %o to double
  store double %conv, ptr %ptr.iv, align 8
  %iv.next = add nsw i64 %iv, 2
  %ptr.iv.next = getelementptr i8, ptr %ptr.iv, i64 8
  %iv.clamp = and i64 %iv, 4294967294
  %ec = icmp eq i64 %iv.clamp, 512
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @low_trip_count_fold_tail_scalarized_store(ptr %dst) {
; DEFAULT-LABEL: define void @low_trip_count_fold_tail_scalarized_store(
; DEFAULT-SAME: ptr [[DST:%.*]]) {
; DEFAULT-NEXT:  [[ENTRY:.*]]:
; DEFAULT-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; DEFAULT:       [[VECTOR_PH]]:
; DEFAULT-NEXT:    br label %[[VECTOR_BODY:.*]]
; DEFAULT:       [[VECTOR_BODY]]:
; DEFAULT-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[PRED_STORE_CONTINUE14:.*]] ]
; DEFAULT-NEXT:    [[VEC_IND:%.*]] = phi <8 x i8> [ <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[PRED_STORE_CONTINUE14]] ]
; DEFAULT-NEXT:    [[TMP0:%.*]] = trunc i64 [[INDEX]] to i8
; DEFAULT-NEXT:    [[TMP1:%.*]] = icmp ule <8 x i8> [[VEC_IND]], splat (i8 6)
; DEFAULT-NEXT:    [[TMP2:%.*]] = extractelement <8 x i1> [[TMP1]], i32 0
; DEFAULT-NEXT:    br i1 [[TMP2]], label %[[PRED_STORE_IF:.*]], label %[[PRED_STORE_CONTINUE:.*]]
; DEFAULT:       [[PRED_STORE_IF]]:
; DEFAULT-NEXT:    [[TMP3:%.*]] = add i64 [[INDEX]], 0
; DEFAULT-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP3]]
; DEFAULT-NEXT:    [[TMP5:%.*]] = add i8 [[TMP0]], 0
; DEFAULT-NEXT:    store i8 [[TMP5]], ptr [[TMP4]], align 1
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE]]
; DEFAULT:       [[PRED_STORE_CONTINUE]]:
; DEFAULT-NEXT:    [[TMP6:%.*]] = extractelement <8 x i1> [[TMP1]], i32 1
; DEFAULT-NEXT:    br i1 [[TMP6]], label %[[PRED_STORE_IF1:.*]], label %[[PRED_STORE_CONTINUE2:.*]]
; DEFAULT:       [[PRED_STORE_IF1]]:
; DEFAULT-NEXT:    [[TMP7:%.*]] = add i64 [[INDEX]], 1
; DEFAULT-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP7]]
; DEFAULT-NEXT:    [[TMP9:%.*]] = add i8 [[TMP0]], 1
; DEFAULT-NEXT:    store i8 [[TMP9]], ptr [[TMP8]], align 1
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE2]]
; DEFAULT:       [[PRED_STORE_CONTINUE2]]:
; DEFAULT-NEXT:    [[TMP10:%.*]] = extractelement <8 x i1> [[TMP1]], i32 2
; DEFAULT-NEXT:    br i1 [[TMP10]], label %[[PRED_STORE_IF3:.*]], label %[[PRED_STORE_CONTINUE4:.*]]
; DEFAULT:       [[PRED_STORE_IF3]]:
; DEFAULT-NEXT:    [[TMP11:%.*]] = add i64 [[INDEX]], 2
; DEFAULT-NEXT:    [[TMP12:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP11]]
; DEFAULT-NEXT:    [[TMP13:%.*]] = add i8 [[TMP0]], 2
; DEFAULT-NEXT:    store i8 [[TMP13]], ptr [[TMP12]], align 1
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE4]]
; DEFAULT:       [[PRED_STORE_CONTINUE4]]:
; DEFAULT-NEXT:    [[TMP14:%.*]] = extractelement <8 x i1> [[TMP1]], i32 3
; DEFAULT-NEXT:    br i1 [[TMP14]], label %[[PRED_STORE_IF5:.*]], label %[[PRED_STORE_CONTINUE6:.*]]
; DEFAULT:       [[PRED_STORE_IF5]]:
; DEFAULT-NEXT:    [[TMP15:%.*]] = add i64 [[INDEX]], 3
; DEFAULT-NEXT:    [[TMP16:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP15]]
; DEFAULT-NEXT:    [[TMP17:%.*]] = add i8 [[TMP0]], 3
; DEFAULT-NEXT:    store i8 [[TMP17]], ptr [[TMP16]], align 1
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE6]]
; DEFAULT:       [[PRED_STORE_CONTINUE6]]:
; DEFAULT-NEXT:    [[TMP18:%.*]] = extractelement <8 x i1> [[TMP1]], i32 4
; DEFAULT-NEXT:    br i1 [[TMP18]], label %[[PRED_STORE_IF7:.*]], label %[[PRED_STORE_CONTINUE8:.*]]
; DEFAULT:       [[PRED_STORE_IF7]]:
; DEFAULT-NEXT:    [[TMP19:%.*]] = add i64 [[INDEX]], 4
; DEFAULT-NEXT:    [[TMP20:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP19]]
; DEFAULT-NEXT:    [[TMP21:%.*]] = add i8 [[TMP0]], 4
; DEFAULT-NEXT:    store i8 [[TMP21]], ptr [[TMP20]], align 1
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE8]]
; DEFAULT:       [[PRED_STORE_CONTINUE8]]:
; DEFAULT-NEXT:    [[TMP22:%.*]] = extractelement <8 x i1> [[TMP1]], i32 5
; DEFAULT-NEXT:    br i1 [[TMP22]], label %[[PRED_STORE_IF9:.*]], label %[[PRED_STORE_CONTINUE10:.*]]
; DEFAULT:       [[PRED_STORE_IF9]]:
; DEFAULT-NEXT:    [[TMP23:%.*]] = add i64 [[INDEX]], 5
; DEFAULT-NEXT:    [[TMP24:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP23]]
; DEFAULT-NEXT:    [[TMP25:%.*]] = add i8 [[TMP0]], 5
; DEFAULT-NEXT:    store i8 [[TMP25]], ptr [[TMP24]], align 1
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE10]]
; DEFAULT:       [[PRED_STORE_CONTINUE10]]:
; DEFAULT-NEXT:    [[TMP26:%.*]] = extractelement <8 x i1> [[TMP1]], i32 6
; DEFAULT-NEXT:    br i1 [[TMP26]], label %[[PRED_STORE_IF11:.*]], label %[[PRED_STORE_CONTINUE12:.*]]
; DEFAULT:       [[PRED_STORE_IF11]]:
; DEFAULT-NEXT:    [[TMP27:%.*]] = add i64 [[INDEX]], 6
; DEFAULT-NEXT:    [[TMP28:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP27]]
; DEFAULT-NEXT:    [[TMP29:%.*]] = add i8 [[TMP0]], 6
; DEFAULT-NEXT:    store i8 [[TMP29]], ptr [[TMP28]], align 1
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE12]]
; DEFAULT:       [[PRED_STORE_CONTINUE12]]:
; DEFAULT-NEXT:    [[TMP30:%.*]] = extractelement <8 x i1> [[TMP1]], i32 7
; DEFAULT-NEXT:    br i1 [[TMP30]], label %[[PRED_STORE_IF13:.*]], label %[[PRED_STORE_CONTINUE14]]
; DEFAULT:       [[PRED_STORE_IF13]]:
; DEFAULT-NEXT:    [[TMP31:%.*]] = add i64 [[INDEX]], 7
; DEFAULT-NEXT:    [[TMP32:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP31]]
; DEFAULT-NEXT:    [[TMP33:%.*]] = add i8 [[TMP0]], 7
; DEFAULT-NEXT:    store i8 [[TMP33]], ptr [[TMP32]], align 1
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE14]]
; DEFAULT:       [[PRED_STORE_CONTINUE14]]:
; DEFAULT-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 8
; DEFAULT-NEXT:    [[VEC_IND_NEXT]] = add <8 x i8> [[VEC_IND]], splat (i8 8)
; DEFAULT-NEXT:    br i1 true, label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP24:![0-9]+]]
; DEFAULT:       [[MIDDLE_BLOCK]]:
; DEFAULT-NEXT:    br label %[[EXIT:.*]]
; DEFAULT:       [[SCALAR_PH]]:
; DEFAULT-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 0, %[[ENTRY]] ]
; DEFAULT-NEXT:    br label %[[LOOP:.*]]
; DEFAULT:       [[LOOP]]:
; DEFAULT-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; DEFAULT-NEXT:    [[IV_TRUNC:%.*]] = trunc i64 [[IV]] to i8
; DEFAULT-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[DST]], i64 [[IV]]
; DEFAULT-NEXT:    store i8 [[IV_TRUNC]], ptr [[GEP]], align 1
; DEFAULT-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; DEFAULT-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], 7
; DEFAULT-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP25:![0-9]+]]
; DEFAULT:       [[EXIT]]:
; DEFAULT-NEXT:    ret void
;
; PRED-LABEL: define void @low_trip_count_fold_tail_scalarized_store(
; PRED-SAME: ptr [[DST:%.*]]) {
; PRED-NEXT:  [[ENTRY:.*]]:
; PRED-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; PRED:       [[VECTOR_PH]]:
; PRED-NEXT:    br label %[[VECTOR_BODY:.*]]
; PRED:       [[VECTOR_BODY]]:
; PRED-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[PRED_STORE_CONTINUE14:.*]] ]
; PRED-NEXT:    [[VEC_IND:%.*]] = phi <8 x i8> [ <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[PRED_STORE_CONTINUE14]] ]
; PRED-NEXT:    [[TMP0:%.*]] = trunc i64 [[INDEX]] to i8
; PRED-NEXT:    [[TMP1:%.*]] = icmp ule <8 x i8> [[VEC_IND]], splat (i8 6)
; PRED-NEXT:    [[TMP2:%.*]] = extractelement <8 x i1> [[TMP1]], i32 0
; PRED-NEXT:    br i1 [[TMP2]], label %[[PRED_STORE_IF:.*]], label %[[PRED_STORE_CONTINUE:.*]]
; PRED:       [[PRED_STORE_IF]]:
; PRED-NEXT:    [[TMP3:%.*]] = add i64 [[INDEX]], 0
; PRED-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP3]]
; PRED-NEXT:    [[TMP5:%.*]] = add i8 [[TMP0]], 0
; PRED-NEXT:    store i8 [[TMP5]], ptr [[TMP4]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE]]
; PRED:       [[PRED_STORE_CONTINUE]]:
; PRED-NEXT:    [[TMP6:%.*]] = extractelement <8 x i1> [[TMP1]], i32 1
; PRED-NEXT:    br i1 [[TMP6]], label %[[PRED_STORE_IF1:.*]], label %[[PRED_STORE_CONTINUE2:.*]]
; PRED:       [[PRED_STORE_IF1]]:
; PRED-NEXT:    [[TMP7:%.*]] = add i64 [[INDEX]], 1
; PRED-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP7]]
; PRED-NEXT:    [[TMP9:%.*]] = add i8 [[TMP0]], 1
; PRED-NEXT:    store i8 [[TMP9]], ptr [[TMP8]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE2]]
; PRED:       [[PRED_STORE_CONTINUE2]]:
; PRED-NEXT:    [[TMP10:%.*]] = extractelement <8 x i1> [[TMP1]], i32 2
; PRED-NEXT:    br i1 [[TMP10]], label %[[PRED_STORE_IF3:.*]], label %[[PRED_STORE_CONTINUE4:.*]]
; PRED:       [[PRED_STORE_IF3]]:
; PRED-NEXT:    [[TMP11:%.*]] = add i64 [[INDEX]], 2
; PRED-NEXT:    [[TMP12:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP11]]
; PRED-NEXT:    [[TMP13:%.*]] = add i8 [[TMP0]], 2
; PRED-NEXT:    store i8 [[TMP13]], ptr [[TMP12]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE4]]
; PRED:       [[PRED_STORE_CONTINUE4]]:
; PRED-NEXT:    [[TMP14:%.*]] = extractelement <8 x i1> [[TMP1]], i32 3
; PRED-NEXT:    br i1 [[TMP14]], label %[[PRED_STORE_IF5:.*]], label %[[PRED_STORE_CONTINUE6:.*]]
; PRED:       [[PRED_STORE_IF5]]:
; PRED-NEXT:    [[TMP15:%.*]] = add i64 [[INDEX]], 3
; PRED-NEXT:    [[TMP16:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP15]]
; PRED-NEXT:    [[TMP17:%.*]] = add i8 [[TMP0]], 3
; PRED-NEXT:    store i8 [[TMP17]], ptr [[TMP16]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE6]]
; PRED:       [[PRED_STORE_CONTINUE6]]:
; PRED-NEXT:    [[TMP18:%.*]] = extractelement <8 x i1> [[TMP1]], i32 4
; PRED-NEXT:    br i1 [[TMP18]], label %[[PRED_STORE_IF7:.*]], label %[[PRED_STORE_CONTINUE8:.*]]
; PRED:       [[PRED_STORE_IF7]]:
; PRED-NEXT:    [[TMP19:%.*]] = add i64 [[INDEX]], 4
; PRED-NEXT:    [[TMP20:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP19]]
; PRED-NEXT:    [[TMP21:%.*]] = add i8 [[TMP0]], 4
; PRED-NEXT:    store i8 [[TMP21]], ptr [[TMP20]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE8]]
; PRED:       [[PRED_STORE_CONTINUE8]]:
; PRED-NEXT:    [[TMP22:%.*]] = extractelement <8 x i1> [[TMP1]], i32 5
; PRED-NEXT:    br i1 [[TMP22]], label %[[PRED_STORE_IF9:.*]], label %[[PRED_STORE_CONTINUE10:.*]]
; PRED:       [[PRED_STORE_IF9]]:
; PRED-NEXT:    [[TMP23:%.*]] = add i64 [[INDEX]], 5
; PRED-NEXT:    [[TMP24:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP23]]
; PRED-NEXT:    [[TMP25:%.*]] = add i8 [[TMP0]], 5
; PRED-NEXT:    store i8 [[TMP25]], ptr [[TMP24]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE10]]
; PRED:       [[PRED_STORE_CONTINUE10]]:
; PRED-NEXT:    [[TMP26:%.*]] = extractelement <8 x i1> [[TMP1]], i32 6
; PRED-NEXT:    br i1 [[TMP26]], label %[[PRED_STORE_IF11:.*]], label %[[PRED_STORE_CONTINUE12:.*]]
; PRED:       [[PRED_STORE_IF11]]:
; PRED-NEXT:    [[TMP27:%.*]] = add i64 [[INDEX]], 6
; PRED-NEXT:    [[TMP28:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP27]]
; PRED-NEXT:    [[TMP29:%.*]] = add i8 [[TMP0]], 6
; PRED-NEXT:    store i8 [[TMP29]], ptr [[TMP28]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE12]]
; PRED:       [[PRED_STORE_CONTINUE12]]:
; PRED-NEXT:    [[TMP30:%.*]] = extractelement <8 x i1> [[TMP1]], i32 7
; PRED-NEXT:    br i1 [[TMP30]], label %[[PRED_STORE_IF13:.*]], label %[[PRED_STORE_CONTINUE14]]
; PRED:       [[PRED_STORE_IF13]]:
; PRED-NEXT:    [[TMP31:%.*]] = add i64 [[INDEX]], 7
; PRED-NEXT:    [[TMP32:%.*]] = getelementptr i8, ptr [[DST]], i64 [[TMP31]]
; PRED-NEXT:    [[TMP33:%.*]] = add i8 [[TMP0]], 7
; PRED-NEXT:    store i8 [[TMP33]], ptr [[TMP32]], align 1
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE14]]
; PRED:       [[PRED_STORE_CONTINUE14]]:
; PRED-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 8
; PRED-NEXT:    [[VEC_IND_NEXT]] = add <8 x i8> [[VEC_IND]], splat (i8 8)
; PRED-NEXT:    br i1 true, label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP6:![0-9]+]]
; PRED:       [[MIDDLE_BLOCK]]:
; PRED-NEXT:    br label %[[EXIT:.*]]
; PRED:       [[SCALAR_PH]]:
; PRED-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 0, %[[ENTRY]] ]
; PRED-NEXT:    br label %[[LOOP:.*]]
; PRED:       [[LOOP]]:
; PRED-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; PRED-NEXT:    [[IV_TRUNC:%.*]] = trunc i64 [[IV]] to i8
; PRED-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[DST]], i64 [[IV]]
; PRED-NEXT:    store i8 [[IV_TRUNC]], ptr [[GEP]], align 1
; PRED-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; PRED-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], 7
; PRED-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP7:![0-9]+]]
; PRED:       [[EXIT]]:
; PRED-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %iv.trunc = trunc i64 %iv to i8
  %gep = getelementptr i8, ptr %dst, i64 %iv
  store i8 %iv.trunc, ptr %gep, align 1
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv.next, 7
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_conditional_interleave_group (ptr noalias %src.1, ptr noalias %src.2, ptr noalias %src.3, ptr noalias %src.4, ptr noalias %dst, i64 %N) #2 {
; DEFAULT-LABEL: define void @test_conditional_interleave_group(
; DEFAULT-SAME: ptr noalias [[SRC_1:%.*]], ptr noalias [[SRC_2:%.*]], ptr noalias [[SRC_3:%.*]], ptr noalias [[SRC_4:%.*]], ptr noalias [[DST:%.*]], i64 [[N:%.*]]) #[[ATTR3:[0-9]+]] {
; DEFAULT-NEXT:  [[ENTRY:.*]]:
; DEFAULT-NEXT:    [[TMP0:%.*]] = add i64 [[N]], 1
; DEFAULT-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[TMP0]], 8
; DEFAULT-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_SCEVCHECK:.*]]
; DEFAULT:       [[VECTOR_SCEVCHECK]]:
; DEFAULT-NEXT:    [[MUL:%.*]] = call { i64, i1 } @llvm.umul.with.overflow.i64(i64 16, i64 [[N]])
; DEFAULT-NEXT:    [[MUL_RESULT:%.*]] = extractvalue { i64, i1 } [[MUL]], 0
; DEFAULT-NEXT:    [[MUL_OVERFLOW:%.*]] = extractvalue { i64, i1 } [[MUL]], 1
; DEFAULT-NEXT:    [[TMP1:%.*]] = sub i64 0, [[MUL_RESULT]]
; DEFAULT-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[DST]], i64 [[MUL_RESULT]]
; DEFAULT-NEXT:    [[TMP3:%.*]] = icmp ult ptr [[TMP2]], [[DST]]
; DEFAULT-NEXT:    [[TMP4:%.*]] = or i1 [[TMP3]], [[MUL_OVERFLOW]]
; DEFAULT-NEXT:    [[SCEVGEP:%.*]] = getelementptr i8, ptr [[DST]], i64 4
; DEFAULT-NEXT:    [[MUL1:%.*]] = call { i64, i1 } @llvm.umul.with.overflow.i64(i64 16, i64 [[N]])
; DEFAULT-NEXT:    [[MUL_RESULT2:%.*]] = extractvalue { i64, i1 } [[MUL1]], 0
; DEFAULT-NEXT:    [[MUL_OVERFLOW3:%.*]] = extractvalue { i64, i1 } [[MUL1]], 1
; DEFAULT-NEXT:    [[TMP5:%.*]] = sub i64 0, [[MUL_RESULT2]]
; DEFAULT-NEXT:    [[TMP6:%.*]] = getelementptr i8, ptr [[SCEVGEP]], i64 [[MUL_RESULT2]]
; DEFAULT-NEXT:    [[TMP7:%.*]] = icmp ult ptr [[TMP6]], [[SCEVGEP]]
; DEFAULT-NEXT:    [[TMP8:%.*]] = or i1 [[TMP7]], [[MUL_OVERFLOW3]]
; DEFAULT-NEXT:    [[SCEVGEP4:%.*]] = getelementptr i8, ptr [[DST]], i64 8
; DEFAULT-NEXT:    [[MUL5:%.*]] = call { i64, i1 } @llvm.umul.with.overflow.i64(i64 16, i64 [[N]])
; DEFAULT-NEXT:    [[MUL_RESULT6:%.*]] = extractvalue { i64, i1 } [[MUL5]], 0
; DEFAULT-NEXT:    [[MUL_OVERFLOW7:%.*]] = extractvalue { i64, i1 } [[MUL5]], 1
; DEFAULT-NEXT:    [[TMP9:%.*]] = sub i64 0, [[MUL_RESULT6]]
; DEFAULT-NEXT:    [[TMP10:%.*]] = getelementptr i8, ptr [[SCEVGEP4]], i64 [[MUL_RESULT6]]
; DEFAULT-NEXT:    [[TMP11:%.*]] = icmp ult ptr [[TMP10]], [[SCEVGEP4]]
; DEFAULT-NEXT:    [[TMP12:%.*]] = or i1 [[TMP11]], [[MUL_OVERFLOW7]]
; DEFAULT-NEXT:    [[TMP13:%.*]] = or i1 [[TMP4]], [[TMP8]]
; DEFAULT-NEXT:    [[TMP14:%.*]] = or i1 [[TMP13]], [[TMP12]]
; DEFAULT-NEXT:    br i1 [[TMP14]], label %[[SCALAR_PH]], label %[[VECTOR_PH:.*]]
; DEFAULT:       [[VECTOR_PH]]:
; DEFAULT-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[TMP0]], 8
; DEFAULT-NEXT:    [[N_VEC:%.*]] = sub i64 [[TMP0]], [[N_MOD_VF]]
; DEFAULT-NEXT:    br label %[[VECTOR_BODY:.*]]
; DEFAULT:       [[VECTOR_BODY]]:
; DEFAULT-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[PRED_STORE_CONTINUE27:.*]] ]
; DEFAULT-NEXT:    [[VEC_IND:%.*]] = phi <8 x i64> [ <i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6, i64 7>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[PRED_STORE_CONTINUE27]] ]
; DEFAULT-NEXT:    [[TMP15:%.*]] = load float, ptr [[SRC_1]], align 4
; DEFAULT-NEXT:    [[BROADCAST_SPLATINSERT8:%.*]] = insertelement <8 x float> poison, float [[TMP15]], i64 0
; DEFAULT-NEXT:    [[BROADCAST_SPLAT9:%.*]] = shufflevector <8 x float> [[BROADCAST_SPLATINSERT8]], <8 x float> poison, <8 x i32> zeroinitializer
; DEFAULT-NEXT:    [[TMP16:%.*]] = load float, ptr [[SRC_2]], align 4
; DEFAULT-NEXT:    [[BROADCAST_SPLATINSERT:%.*]] = insertelement <8 x float> poison, float [[TMP16]], i64 0
; DEFAULT-NEXT:    [[BROADCAST_SPLAT:%.*]] = shufflevector <8 x float> [[BROADCAST_SPLATINSERT]], <8 x float> poison, <8 x i32> zeroinitializer
; DEFAULT-NEXT:    [[TMP17:%.*]] = fmul <8 x float> [[BROADCAST_SPLAT]], zeroinitializer
; DEFAULT-NEXT:    [[TMP18:%.*]] = call <8 x float> @llvm.fmuladd.v8f32(<8 x float> [[BROADCAST_SPLAT9]], <8 x float> zeroinitializer, <8 x float> [[TMP17]])
; DEFAULT-NEXT:    [[TMP19:%.*]] = load float, ptr [[SRC_3]], align 4
; DEFAULT-NEXT:    [[BROADCAST_SPLATINSERT10:%.*]] = insertelement <8 x float> poison, float [[TMP19]], i64 0
; DEFAULT-NEXT:    [[BROADCAST_SPLAT11:%.*]] = shufflevector <8 x float> [[BROADCAST_SPLATINSERT10]], <8 x float> poison, <8 x i32> zeroinitializer
; DEFAULT-NEXT:    [[TMP20:%.*]] = call <8 x float> @llvm.fmuladd.v8f32(<8 x float> [[BROADCAST_SPLAT11]], <8 x float> zeroinitializer, <8 x float> [[TMP18]])
; DEFAULT-NEXT:    [[TMP21:%.*]] = load float, ptr [[SRC_3]], align 4
; DEFAULT-NEXT:    [[BROADCAST_SPLATINSERT12:%.*]] = insertelement <8 x float> poison, float [[TMP21]], i64 0
; DEFAULT-NEXT:    [[BROADCAST_SPLAT13:%.*]] = shufflevector <8 x float> [[BROADCAST_SPLATINSERT12]], <8 x float> poison, <8 x i32> zeroinitializer
; DEFAULT-NEXT:    [[TMP22:%.*]] = fcmp ogt <8 x float> [[TMP20]], [[BROADCAST_SPLAT13]]
; DEFAULT-NEXT:    [[TMP23:%.*]] = getelementptr { [4 x float] }, ptr [[DST]], <8 x i64> [[VEC_IND]]
; DEFAULT-NEXT:    [[TMP24:%.*]] = extractelement <8 x i1> [[TMP22]], i32 0
; DEFAULT-NEXT:    br i1 [[TMP24]], label %[[PRED_STORE_IF:.*]], label %[[PRED_STORE_CONTINUE:.*]]
; DEFAULT:       [[PRED_STORE_IF]]:
; DEFAULT-NEXT:    [[TMP25:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 0
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP25]], align 4
; DEFAULT-NEXT:    [[TMP26:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 0
; DEFAULT-NEXT:    [[TMP27:%.*]] = getelementptr i8, ptr [[TMP26]], i64 4
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP27]], align 4
; DEFAULT-NEXT:    [[TMP28:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 0
; DEFAULT-NEXT:    [[TMP29:%.*]] = getelementptr i8, ptr [[TMP28]], i64 8
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP29]], align 4
; DEFAULT-NEXT:    [[TMP30:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 0
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP30]], align 4
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE]]
; DEFAULT:       [[PRED_STORE_CONTINUE]]:
; DEFAULT-NEXT:    [[TMP31:%.*]] = extractelement <8 x i1> [[TMP22]], i32 1
; DEFAULT-NEXT:    br i1 [[TMP31]], label %[[PRED_STORE_IF14:.*]], label %[[PRED_STORE_CONTINUE15:.*]]
; DEFAULT:       [[PRED_STORE_IF14]]:
; DEFAULT-NEXT:    [[TMP32:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 1
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP32]], align 4
; DEFAULT-NEXT:    [[TMP33:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 1
; DEFAULT-NEXT:    [[TMP34:%.*]] = getelementptr i8, ptr [[TMP33]], i64 4
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP34]], align 4
; DEFAULT-NEXT:    [[TMP35:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 1
; DEFAULT-NEXT:    [[TMP36:%.*]] = getelementptr i8, ptr [[TMP35]], i64 8
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP36]], align 4
; DEFAULT-NEXT:    [[TMP37:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 1
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP37]], align 4
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE15]]
; DEFAULT:       [[PRED_STORE_CONTINUE15]]:
; DEFAULT-NEXT:    [[TMP38:%.*]] = extractelement <8 x i1> [[TMP22]], i32 2
; DEFAULT-NEXT:    br i1 [[TMP38]], label %[[PRED_STORE_IF16:.*]], label %[[PRED_STORE_CONTINUE17:.*]]
; DEFAULT:       [[PRED_STORE_IF16]]:
; DEFAULT-NEXT:    [[TMP39:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 2
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP39]], align 4
; DEFAULT-NEXT:    [[TMP40:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 2
; DEFAULT-NEXT:    [[TMP41:%.*]] = getelementptr i8, ptr [[TMP40]], i64 4
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP41]], align 4
; DEFAULT-NEXT:    [[TMP42:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 2
; DEFAULT-NEXT:    [[TMP43:%.*]] = getelementptr i8, ptr [[TMP42]], i64 8
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP43]], align 4
; DEFAULT-NEXT:    [[TMP44:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 2
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP44]], align 4
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE17]]
; DEFAULT:       [[PRED_STORE_CONTINUE17]]:
; DEFAULT-NEXT:    [[TMP45:%.*]] = extractelement <8 x i1> [[TMP22]], i32 3
; DEFAULT-NEXT:    br i1 [[TMP45]], label %[[PRED_STORE_IF18:.*]], label %[[PRED_STORE_CONTINUE19:.*]]
; DEFAULT:       [[PRED_STORE_IF18]]:
; DEFAULT-NEXT:    [[TMP46:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 3
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP46]], align 4
; DEFAULT-NEXT:    [[TMP47:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 3
; DEFAULT-NEXT:    [[TMP48:%.*]] = getelementptr i8, ptr [[TMP47]], i64 4
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP48]], align 4
; DEFAULT-NEXT:    [[TMP49:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 3
; DEFAULT-NEXT:    [[TMP50:%.*]] = getelementptr i8, ptr [[TMP49]], i64 8
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP50]], align 4
; DEFAULT-NEXT:    [[TMP51:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 3
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP51]], align 4
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE19]]
; DEFAULT:       [[PRED_STORE_CONTINUE19]]:
; DEFAULT-NEXT:    [[TMP52:%.*]] = extractelement <8 x i1> [[TMP22]], i32 4
; DEFAULT-NEXT:    br i1 [[TMP52]], label %[[PRED_STORE_IF20:.*]], label %[[PRED_STORE_CONTINUE21:.*]]
; DEFAULT:       [[PRED_STORE_IF20]]:
; DEFAULT-NEXT:    [[TMP53:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 4
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP53]], align 4
; DEFAULT-NEXT:    [[TMP54:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 4
; DEFAULT-NEXT:    [[TMP55:%.*]] = getelementptr i8, ptr [[TMP54]], i64 4
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP55]], align 4
; DEFAULT-NEXT:    [[TMP56:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 4
; DEFAULT-NEXT:    [[TMP57:%.*]] = getelementptr i8, ptr [[TMP56]], i64 8
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP57]], align 4
; DEFAULT-NEXT:    [[TMP58:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 4
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP58]], align 4
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE21]]
; DEFAULT:       [[PRED_STORE_CONTINUE21]]:
; DEFAULT-NEXT:    [[TMP59:%.*]] = extractelement <8 x i1> [[TMP22]], i32 5
; DEFAULT-NEXT:    br i1 [[TMP59]], label %[[PRED_STORE_IF22:.*]], label %[[PRED_STORE_CONTINUE23:.*]]
; DEFAULT:       [[PRED_STORE_IF22]]:
; DEFAULT-NEXT:    [[TMP60:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 5
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP60]], align 4
; DEFAULT-NEXT:    [[TMP61:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 5
; DEFAULT-NEXT:    [[TMP62:%.*]] = getelementptr i8, ptr [[TMP61]], i64 4
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP62]], align 4
; DEFAULT-NEXT:    [[TMP63:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 5
; DEFAULT-NEXT:    [[TMP64:%.*]] = getelementptr i8, ptr [[TMP63]], i64 8
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP64]], align 4
; DEFAULT-NEXT:    [[TMP65:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 5
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP65]], align 4
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE23]]
; DEFAULT:       [[PRED_STORE_CONTINUE23]]:
; DEFAULT-NEXT:    [[TMP66:%.*]] = extractelement <8 x i1> [[TMP22]], i32 6
; DEFAULT-NEXT:    br i1 [[TMP66]], label %[[PRED_STORE_IF24:.*]], label %[[PRED_STORE_CONTINUE25:.*]]
; DEFAULT:       [[PRED_STORE_IF24]]:
; DEFAULT-NEXT:    [[TMP67:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 6
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP67]], align 4
; DEFAULT-NEXT:    [[TMP68:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 6
; DEFAULT-NEXT:    [[TMP69:%.*]] = getelementptr i8, ptr [[TMP68]], i64 4
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP69]], align 4
; DEFAULT-NEXT:    [[TMP70:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 6
; DEFAULT-NEXT:    [[TMP71:%.*]] = getelementptr i8, ptr [[TMP70]], i64 8
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP71]], align 4
; DEFAULT-NEXT:    [[TMP72:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 6
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP72]], align 4
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE25]]
; DEFAULT:       [[PRED_STORE_CONTINUE25]]:
; DEFAULT-NEXT:    [[TMP73:%.*]] = extractelement <8 x i1> [[TMP22]], i32 7
; DEFAULT-NEXT:    br i1 [[TMP73]], label %[[PRED_STORE_IF26:.*]], label %[[PRED_STORE_CONTINUE27]]
; DEFAULT:       [[PRED_STORE_IF26]]:
; DEFAULT-NEXT:    [[TMP74:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 7
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP74]], align 4
; DEFAULT-NEXT:    [[TMP75:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 7
; DEFAULT-NEXT:    [[TMP76:%.*]] = getelementptr i8, ptr [[TMP75]], i64 4
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP76]], align 4
; DEFAULT-NEXT:    [[TMP77:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 7
; DEFAULT-NEXT:    [[TMP78:%.*]] = getelementptr i8, ptr [[TMP77]], i64 8
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP78]], align 4
; DEFAULT-NEXT:    [[TMP79:%.*]] = extractelement <8 x ptr> [[TMP23]], i32 7
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[TMP79]], align 4
; DEFAULT-NEXT:    br label %[[PRED_STORE_CONTINUE27]]
; DEFAULT:       [[PRED_STORE_CONTINUE27]]:
; DEFAULT-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 8
; DEFAULT-NEXT:    [[VEC_IND_NEXT]] = add <8 x i64> [[VEC_IND]], splat (i64 8)
; DEFAULT-NEXT:    [[TMP80:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; DEFAULT-NEXT:    br i1 [[TMP80]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP26:![0-9]+]]
; DEFAULT:       [[MIDDLE_BLOCK]]:
; DEFAULT-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[TMP0]], [[N_VEC]]
; DEFAULT-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; DEFAULT:       [[SCALAR_PH]]:
; DEFAULT-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ], [ 0, %[[VECTOR_SCEVCHECK]] ]
; DEFAULT-NEXT:    br label %[[LOOP_HEADER:.*]]
; DEFAULT:       [[LOOP_HEADER]]:
; DEFAULT-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; DEFAULT-NEXT:    [[TMP81:%.*]] = load float, ptr [[SRC_1]], align 4
; DEFAULT-NEXT:    [[TMP82:%.*]] = load float, ptr [[SRC_2]], align 4
; DEFAULT-NEXT:    [[MUL8_I_US:%.*]] = fmul float [[TMP82]], 0.000000e+00
; DEFAULT-NEXT:    [[TMP83:%.*]] = tail call float @llvm.fmuladd.f32(float [[TMP81]], float 0.000000e+00, float [[MUL8_I_US]])
; DEFAULT-NEXT:    [[TMP84:%.*]] = load float, ptr [[SRC_3]], align 4
; DEFAULT-NEXT:    [[TMP85:%.*]] = tail call float @llvm.fmuladd.f32(float [[TMP84]], float 0.000000e+00, float [[TMP83]])
; DEFAULT-NEXT:    [[TMP86:%.*]] = load float, ptr [[SRC_3]], align 4
; DEFAULT-NEXT:    [[C:%.*]] = fcmp ogt float [[TMP85]], [[TMP86]]
; DEFAULT-NEXT:    br i1 [[C]], label %[[IF_THEN:.*]], label %[[LOOP_LATCH]]
; DEFAULT:       [[IF_THEN]]:
; DEFAULT-NEXT:    [[DST_0:%.*]] = getelementptr { [4 x float] }, ptr [[DST]], i64 [[IV]]
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[DST_0]], align 4
; DEFAULT-NEXT:    [[DST_1:%.*]] = getelementptr i8, ptr [[DST_0]], i64 4
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[DST_1]], align 4
; DEFAULT-NEXT:    [[DST_2:%.*]] = getelementptr i8, ptr [[DST_0]], i64 8
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[DST_2]], align 4
; DEFAULT-NEXT:    [[DST_3:%.*]] = getelementptr i8, ptr [[DST_0]], i64 16
; DEFAULT-NEXT:    store float 0.000000e+00, ptr [[DST_0]], align 4
; DEFAULT-NEXT:    br label %[[LOOP_LATCH]]
; DEFAULT:       [[LOOP_LATCH]]:
; DEFAULT-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; DEFAULT-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV]], [[N]]
; DEFAULT-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP_HEADER]], !llvm.loop [[LOOP27:![0-9]+]]
; DEFAULT:       [[EXIT]]:
; DEFAULT-NEXT:    ret void
;
; PRED-LABEL: define void @test_conditional_interleave_group(
; PRED-SAME: ptr noalias [[SRC_1:%.*]], ptr noalias [[SRC_2:%.*]], ptr noalias [[SRC_3:%.*]], ptr noalias [[SRC_4:%.*]], ptr noalias [[DST:%.*]], i64 [[N:%.*]]) #[[ATTR3:[0-9]+]] {
; PRED-NEXT:  [[ENTRY:.*]]:
; PRED-NEXT:    [[TMP0:%.*]] = add i64 [[N]], 1
; PRED-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_SCEVCHECK:.*]]
; PRED:       [[VECTOR_SCEVCHECK]]:
; PRED-NEXT:    [[MUL:%.*]] = call { i64, i1 } @llvm.umul.with.overflow.i64(i64 16, i64 [[N]])
; PRED-NEXT:    [[MUL_RESULT:%.*]] = extractvalue { i64, i1 } [[MUL]], 0
; PRED-NEXT:    [[MUL_OVERFLOW:%.*]] = extractvalue { i64, i1 } [[MUL]], 1
; PRED-NEXT:    [[TMP1:%.*]] = sub i64 0, [[MUL_RESULT]]
; PRED-NEXT:    [[TMP2:%.*]] = getelementptr i8, ptr [[DST]], i64 [[MUL_RESULT]]
; PRED-NEXT:    [[TMP3:%.*]] = icmp ult ptr [[TMP2]], [[DST]]
; PRED-NEXT:    [[TMP4:%.*]] = or i1 [[TMP3]], [[MUL_OVERFLOW]]
; PRED-NEXT:    [[SCEVGEP:%.*]] = getelementptr i8, ptr [[DST]], i64 4
; PRED-NEXT:    [[MUL1:%.*]] = call { i64, i1 } @llvm.umul.with.overflow.i64(i64 16, i64 [[N]])
; PRED-NEXT:    [[MUL_RESULT2:%.*]] = extractvalue { i64, i1 } [[MUL1]], 0
; PRED-NEXT:    [[MUL_OVERFLOW3:%.*]] = extractvalue { i64, i1 } [[MUL1]], 1
; PRED-NEXT:    [[TMP5:%.*]] = sub i64 0, [[MUL_RESULT2]]
; PRED-NEXT:    [[TMP6:%.*]] = getelementptr i8, ptr [[SCEVGEP]], i64 [[MUL_RESULT2]]
; PRED-NEXT:    [[TMP7:%.*]] = icmp ult ptr [[TMP6]], [[SCEVGEP]]
; PRED-NEXT:    [[TMP8:%.*]] = or i1 [[TMP7]], [[MUL_OVERFLOW3]]
; PRED-NEXT:    [[SCEVGEP4:%.*]] = getelementptr i8, ptr [[DST]], i64 8
; PRED-NEXT:    [[MUL5:%.*]] = call { i64, i1 } @llvm.umul.with.overflow.i64(i64 16, i64 [[N]])
; PRED-NEXT:    [[MUL_RESULT6:%.*]] = extractvalue { i64, i1 } [[MUL5]], 0
; PRED-NEXT:    [[MUL_OVERFLOW7:%.*]] = extractvalue { i64, i1 } [[MUL5]], 1
; PRED-NEXT:    [[TMP9:%.*]] = sub i64 0, [[MUL_RESULT6]]
; PRED-NEXT:    [[TMP10:%.*]] = getelementptr i8, ptr [[SCEVGEP4]], i64 [[MUL_RESULT6]]
; PRED-NEXT:    [[TMP11:%.*]] = icmp ult ptr [[TMP10]], [[SCEVGEP4]]
; PRED-NEXT:    [[TMP12:%.*]] = or i1 [[TMP11]], [[MUL_OVERFLOW7]]
; PRED-NEXT:    [[TMP13:%.*]] = or i1 [[TMP4]], [[TMP8]]
; PRED-NEXT:    [[TMP14:%.*]] = or i1 [[TMP13]], [[TMP12]]
; PRED-NEXT:    br i1 [[TMP14]], label %[[SCALAR_PH]], label %[[VECTOR_PH:.*]]
; PRED:       [[VECTOR_PH]]:
; PRED-NEXT:    [[N_RND_UP:%.*]] = add i64 [[TMP0]], 7
; PRED-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N_RND_UP]], 8
; PRED-NEXT:    [[N_VEC:%.*]] = sub i64 [[N_RND_UP]], [[N_MOD_VF]]
; PRED-NEXT:    [[TMP15:%.*]] = sub i64 [[TMP0]], 8
; PRED-NEXT:    [[TMP16:%.*]] = icmp ugt i64 [[TMP0]], 8
; PRED-NEXT:    [[TMP17:%.*]] = select i1 [[TMP16]], i64 [[TMP15]], i64 0
; PRED-NEXT:    [[ACTIVE_LANE_MASK_ENTRY:%.*]] = call <8 x i1> @llvm.get.active.lane.mask.v8i1.i64(i64 0, i64 [[TMP0]])
; PRED-NEXT:    br label %[[VECTOR_BODY:.*]]
; PRED:       [[VECTOR_BODY]]:
; PRED-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[PRED_STORE_CONTINUE27:.*]] ]
; PRED-NEXT:    [[ACTIVE_LANE_MASK:%.*]] = phi <8 x i1> [ [[ACTIVE_LANE_MASK_ENTRY]], %[[VECTOR_PH]] ], [ [[ACTIVE_LANE_MASK_NEXT:%.*]], %[[PRED_STORE_CONTINUE27]] ]
; PRED-NEXT:    [[VEC_IND:%.*]] = phi <8 x i64> [ <i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6, i64 7>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[PRED_STORE_CONTINUE27]] ]
; PRED-NEXT:    [[TMP18:%.*]] = load float, ptr [[SRC_1]], align 4
; PRED-NEXT:    [[BROADCAST_SPLATINSERT8:%.*]] = insertelement <8 x float> poison, float [[TMP18]], i64 0
; PRED-NEXT:    [[BROADCAST_SPLAT9:%.*]] = shufflevector <8 x float> [[BROADCAST_SPLATINSERT8]], <8 x float> poison, <8 x i32> zeroinitializer
; PRED-NEXT:    [[TMP19:%.*]] = load float, ptr [[SRC_2]], align 4
; PRED-NEXT:    [[BROADCAST_SPLATINSERT:%.*]] = insertelement <8 x float> poison, float [[TMP19]], i64 0
; PRED-NEXT:    [[BROADCAST_SPLAT:%.*]] = shufflevector <8 x float> [[BROADCAST_SPLATINSERT]], <8 x float> poison, <8 x i32> zeroinitializer
; PRED-NEXT:    [[TMP20:%.*]] = fmul <8 x float> [[BROADCAST_SPLAT]], zeroinitializer
; PRED-NEXT:    [[TMP21:%.*]] = call <8 x float> @llvm.fmuladd.v8f32(<8 x float> [[BROADCAST_SPLAT9]], <8 x float> zeroinitializer, <8 x float> [[TMP20]])
; PRED-NEXT:    [[TMP22:%.*]] = load float, ptr [[SRC_3]], align 4
; PRED-NEXT:    [[BROADCAST_SPLATINSERT10:%.*]] = insertelement <8 x float> poison, float [[TMP22]], i64 0
; PRED-NEXT:    [[BROADCAST_SPLAT11:%.*]] = shufflevector <8 x float> [[BROADCAST_SPLATINSERT10]], <8 x float> poison, <8 x i32> zeroinitializer
; PRED-NEXT:    [[TMP23:%.*]] = call <8 x float> @llvm.fmuladd.v8f32(<8 x float> [[BROADCAST_SPLAT11]], <8 x float> zeroinitializer, <8 x float> [[TMP21]])
; PRED-NEXT:    [[TMP24:%.*]] = load float, ptr [[SRC_3]], align 4
; PRED-NEXT:    [[BROADCAST_SPLATINSERT12:%.*]] = insertelement <8 x float> poison, float [[TMP24]], i64 0
; PRED-NEXT:    [[BROADCAST_SPLAT13:%.*]] = shufflevector <8 x float> [[BROADCAST_SPLATINSERT12]], <8 x float> poison, <8 x i32> zeroinitializer
; PRED-NEXT:    [[TMP25:%.*]] = fcmp ogt <8 x float> [[TMP23]], [[BROADCAST_SPLAT13]]
; PRED-NEXT:    [[TMP26:%.*]] = select <8 x i1> [[ACTIVE_LANE_MASK]], <8 x i1> [[TMP25]], <8 x i1> zeroinitializer
; PRED-NEXT:    [[TMP27:%.*]] = getelementptr { [4 x float] }, ptr [[DST]], <8 x i64> [[VEC_IND]]
; PRED-NEXT:    [[TMP28:%.*]] = extractelement <8 x i1> [[TMP26]], i32 0
; PRED-NEXT:    br i1 [[TMP28]], label %[[PRED_STORE_IF:.*]], label %[[PRED_STORE_CONTINUE:.*]]
; PRED:       [[PRED_STORE_IF]]:
; PRED-NEXT:    [[TMP29:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 0
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP29]], align 4
; PRED-NEXT:    [[TMP30:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 0
; PRED-NEXT:    [[TMP31:%.*]] = getelementptr i8, ptr [[TMP30]], i64 4
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP31]], align 4
; PRED-NEXT:    [[TMP32:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 0
; PRED-NEXT:    [[TMP33:%.*]] = getelementptr i8, ptr [[TMP32]], i64 8
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP33]], align 4
; PRED-NEXT:    [[TMP34:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 0
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP34]], align 4
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE]]
; PRED:       [[PRED_STORE_CONTINUE]]:
; PRED-NEXT:    [[TMP35:%.*]] = extractelement <8 x i1> [[TMP26]], i32 1
; PRED-NEXT:    br i1 [[TMP35]], label %[[PRED_STORE_IF14:.*]], label %[[PRED_STORE_CONTINUE15:.*]]
; PRED:       [[PRED_STORE_IF14]]:
; PRED-NEXT:    [[TMP36:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 1
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP36]], align 4
; PRED-NEXT:    [[TMP37:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 1
; PRED-NEXT:    [[TMP38:%.*]] = getelementptr i8, ptr [[TMP37]], i64 4
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP38]], align 4
; PRED-NEXT:    [[TMP39:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 1
; PRED-NEXT:    [[TMP40:%.*]] = getelementptr i8, ptr [[TMP39]], i64 8
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP40]], align 4
; PRED-NEXT:    [[TMP41:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 1
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP41]], align 4
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE15]]
; PRED:       [[PRED_STORE_CONTINUE15]]:
; PRED-NEXT:    [[TMP42:%.*]] = extractelement <8 x i1> [[TMP26]], i32 2
; PRED-NEXT:    br i1 [[TMP42]], label %[[PRED_STORE_IF16:.*]], label %[[PRED_STORE_CONTINUE17:.*]]
; PRED:       [[PRED_STORE_IF16]]:
; PRED-NEXT:    [[TMP43:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 2
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP43]], align 4
; PRED-NEXT:    [[TMP44:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 2
; PRED-NEXT:    [[TMP45:%.*]] = getelementptr i8, ptr [[TMP44]], i64 4
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP45]], align 4
; PRED-NEXT:    [[TMP46:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 2
; PRED-NEXT:    [[TMP47:%.*]] = getelementptr i8, ptr [[TMP46]], i64 8
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP47]], align 4
; PRED-NEXT:    [[TMP48:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 2
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP48]], align 4
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE17]]
; PRED:       [[PRED_STORE_CONTINUE17]]:
; PRED-NEXT:    [[TMP49:%.*]] = extractelement <8 x i1> [[TMP26]], i32 3
; PRED-NEXT:    br i1 [[TMP49]], label %[[PRED_STORE_IF18:.*]], label %[[PRED_STORE_CONTINUE19:.*]]
; PRED:       [[PRED_STORE_IF18]]:
; PRED-NEXT:    [[TMP50:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 3
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP50]], align 4
; PRED-NEXT:    [[TMP51:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 3
; PRED-NEXT:    [[TMP52:%.*]] = getelementptr i8, ptr [[TMP51]], i64 4
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP52]], align 4
; PRED-NEXT:    [[TMP53:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 3
; PRED-NEXT:    [[TMP54:%.*]] = getelementptr i8, ptr [[TMP53]], i64 8
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP54]], align 4
; PRED-NEXT:    [[TMP55:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 3
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP55]], align 4
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE19]]
; PRED:       [[PRED_STORE_CONTINUE19]]:
; PRED-NEXT:    [[TMP56:%.*]] = extractelement <8 x i1> [[TMP26]], i32 4
; PRED-NEXT:    br i1 [[TMP56]], label %[[PRED_STORE_IF20:.*]], label %[[PRED_STORE_CONTINUE21:.*]]
; PRED:       [[PRED_STORE_IF20]]:
; PRED-NEXT:    [[TMP57:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 4
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP57]], align 4
; PRED-NEXT:    [[TMP58:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 4
; PRED-NEXT:    [[TMP59:%.*]] = getelementptr i8, ptr [[TMP58]], i64 4
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP59]], align 4
; PRED-NEXT:    [[TMP60:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 4
; PRED-NEXT:    [[TMP61:%.*]] = getelementptr i8, ptr [[TMP60]], i64 8
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP61]], align 4
; PRED-NEXT:    [[TMP62:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 4
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP62]], align 4
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE21]]
; PRED:       [[PRED_STORE_CONTINUE21]]:
; PRED-NEXT:    [[TMP63:%.*]] = extractelement <8 x i1> [[TMP26]], i32 5
; PRED-NEXT:    br i1 [[TMP63]], label %[[PRED_STORE_IF22:.*]], label %[[PRED_STORE_CONTINUE23:.*]]
; PRED:       [[PRED_STORE_IF22]]:
; PRED-NEXT:    [[TMP64:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 5
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP64]], align 4
; PRED-NEXT:    [[TMP65:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 5
; PRED-NEXT:    [[TMP66:%.*]] = getelementptr i8, ptr [[TMP65]], i64 4
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP66]], align 4
; PRED-NEXT:    [[TMP67:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 5
; PRED-NEXT:    [[TMP68:%.*]] = getelementptr i8, ptr [[TMP67]], i64 8
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP68]], align 4
; PRED-NEXT:    [[TMP69:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 5
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP69]], align 4
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE23]]
; PRED:       [[PRED_STORE_CONTINUE23]]:
; PRED-NEXT:    [[TMP70:%.*]] = extractelement <8 x i1> [[TMP26]], i32 6
; PRED-NEXT:    br i1 [[TMP70]], label %[[PRED_STORE_IF24:.*]], label %[[PRED_STORE_CONTINUE25:.*]]
; PRED:       [[PRED_STORE_IF24]]:
; PRED-NEXT:    [[TMP71:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 6
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP71]], align 4
; PRED-NEXT:    [[TMP72:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 6
; PRED-NEXT:    [[TMP73:%.*]] = getelementptr i8, ptr [[TMP72]], i64 4
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP73]], align 4
; PRED-NEXT:    [[TMP74:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 6
; PRED-NEXT:    [[TMP75:%.*]] = getelementptr i8, ptr [[TMP74]], i64 8
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP75]], align 4
; PRED-NEXT:    [[TMP76:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 6
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP76]], align 4
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE25]]
; PRED:       [[PRED_STORE_CONTINUE25]]:
; PRED-NEXT:    [[TMP77:%.*]] = extractelement <8 x i1> [[TMP26]], i32 7
; PRED-NEXT:    br i1 [[TMP77]], label %[[PRED_STORE_IF26:.*]], label %[[PRED_STORE_CONTINUE27]]
; PRED:       [[PRED_STORE_IF26]]:
; PRED-NEXT:    [[TMP78:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 7
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP78]], align 4
; PRED-NEXT:    [[TMP79:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 7
; PRED-NEXT:    [[TMP80:%.*]] = getelementptr i8, ptr [[TMP79]], i64 4
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP80]], align 4
; PRED-NEXT:    [[TMP81:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 7
; PRED-NEXT:    [[TMP82:%.*]] = getelementptr i8, ptr [[TMP81]], i64 8
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP82]], align 4
; PRED-NEXT:    [[TMP83:%.*]] = extractelement <8 x ptr> [[TMP27]], i32 7
; PRED-NEXT:    store float 0.000000e+00, ptr [[TMP83]], align 4
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE27]]
; PRED:       [[PRED_STORE_CONTINUE27]]:
; PRED-NEXT:    [[INDEX_NEXT]] = add i64 [[INDEX]], 8
; PRED-NEXT:    [[ACTIVE_LANE_MASK_NEXT]] = call <8 x i1> @llvm.get.active.lane.mask.v8i1.i64(i64 [[INDEX]], i64 [[TMP17]])
; PRED-NEXT:    [[TMP84:%.*]] = xor <8 x i1> [[ACTIVE_LANE_MASK_NEXT]], splat (i1 true)
; PRED-NEXT:    [[VEC_IND_NEXT]] = add <8 x i64> [[VEC_IND]], splat (i64 8)
; PRED-NEXT:    [[TMP85:%.*]] = extractelement <8 x i1> [[TMP84]], i32 0
; PRED-NEXT:    br i1 [[TMP85]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP8:![0-9]+]]
; PRED:       [[MIDDLE_BLOCK]]:
; PRED-NEXT:    br label %[[EXIT:.*]]
; PRED:       [[SCALAR_PH]]:
; PRED-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 0, %[[ENTRY]] ], [ 0, %[[VECTOR_SCEVCHECK]] ]
; PRED-NEXT:    br label %[[LOOP_HEADER:.*]]
; PRED:       [[LOOP_HEADER]]:
; PRED-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; PRED-NEXT:    [[TMP86:%.*]] = load float, ptr [[SRC_1]], align 4
; PRED-NEXT:    [[TMP87:%.*]] = load float, ptr [[SRC_2]], align 4
; PRED-NEXT:    [[MUL8_I_US:%.*]] = fmul float [[TMP87]], 0.000000e+00
; PRED-NEXT:    [[TMP88:%.*]] = tail call float @llvm.fmuladd.f32(float [[TMP86]], float 0.000000e+00, float [[MUL8_I_US]])
; PRED-NEXT:    [[TMP89:%.*]] = load float, ptr [[SRC_3]], align 4
; PRED-NEXT:    [[TMP90:%.*]] = tail call float @llvm.fmuladd.f32(float [[TMP89]], float 0.000000e+00, float [[TMP88]])
; PRED-NEXT:    [[TMP91:%.*]] = load float, ptr [[SRC_3]], align 4
; PRED-NEXT:    [[C:%.*]] = fcmp ogt float [[TMP90]], [[TMP91]]
; PRED-NEXT:    br i1 [[C]], label %[[IF_THEN:.*]], label %[[LOOP_LATCH]]
; PRED:       [[IF_THEN]]:
; PRED-NEXT:    [[DST_0:%.*]] = getelementptr { [4 x float] }, ptr [[DST]], i64 [[IV]]
; PRED-NEXT:    store float 0.000000e+00, ptr [[DST_0]], align 4
; PRED-NEXT:    [[DST_1:%.*]] = getelementptr i8, ptr [[DST_0]], i64 4
; PRED-NEXT:    store float 0.000000e+00, ptr [[DST_1]], align 4
; PRED-NEXT:    [[DST_2:%.*]] = getelementptr i8, ptr [[DST_0]], i64 8
; PRED-NEXT:    store float 0.000000e+00, ptr [[DST_2]], align 4
; PRED-NEXT:    [[DST_3:%.*]] = getelementptr i8, ptr [[DST_0]], i64 16
; PRED-NEXT:    store float 0.000000e+00, ptr [[DST_0]], align 4
; PRED-NEXT:    br label %[[LOOP_LATCH]]
; PRED:       [[LOOP_LATCH]]:
; PRED-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; PRED-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV]], [[N]]
; PRED-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP_HEADER]], !llvm.loop [[LOOP9:![0-9]+]]
; PRED:       [[EXIT]]:
; PRED-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %0 = load float, ptr %src.1, align 4
  %1 = load float, ptr %src.2, align 4
  %mul8.i.us = fmul float %1, 0.000000e+00
  %2 = tail call float @llvm.fmuladd.f32(float %0, float 0.000000e+00, float %mul8.i.us)
  %3 = load float, ptr %src.3, align 4
  %4 = tail call float @llvm.fmuladd.f32(float %3, float 0.000000e+00, float %2)
  %5 = load float, ptr %src.3, align 4
  %c = fcmp ogt float %4, %5
  br i1 %c, label %if.then, label %loop.latch

if.then:
  %dst.0 = getelementptr { [4 x float] }, ptr %dst, i64 %iv
  store float 0.000000e+00, ptr %dst.0, align 4
  %dst.1 = getelementptr i8, ptr %dst.0, i64 4
  store float 0.000000e+00, ptr %dst.1, align 4
  %dst.2 = getelementptr i8, ptr %dst.0, i64 8
  store float 0.000000e+00, ptr %dst.2, align 4
  %dst.3 = getelementptr i8, ptr %dst.0, i64 16
  store float 0.000000e+00, ptr %dst.0, align 4
  br label %loop.latch

loop.latch:
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %N
  br i1 %ec, label %exit, label %loop.header, !llvm.loop !0

exit:
  ret void
}

define void @redundant_branch_and_tail_folding(ptr %dst, i1 %c) {
; DEFAULT-LABEL: define void @redundant_branch_and_tail_folding(
; DEFAULT-SAME: ptr [[DST:%.*]], i1 [[C:%.*]]) {
; DEFAULT-NEXT:  [[ENTRY:.*]]:
; DEFAULT-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; DEFAULT:       [[VECTOR_PH]]:
; DEFAULT-NEXT:    br label %[[VECTOR_BODY:.*]]
; DEFAULT:       [[VECTOR_BODY]]:
; DEFAULT-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; DEFAULT-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[VECTOR_BODY]] ]
; DEFAULT-NEXT:    [[STEP_ADD:%.*]] = add <4 x i64> [[VEC_IND]], splat (i64 4)
; DEFAULT-NEXT:    [[TMP0:%.*]] = add nuw nsw <4 x i64> [[STEP_ADD]], splat (i64 1)
; DEFAULT-NEXT:    [[TMP1:%.*]] = trunc nuw nsw <4 x i64> [[TMP0]] to <4 x i32>
; DEFAULT-NEXT:    [[TMP2:%.*]] = extractelement <4 x i32> [[TMP1]], i32 3
; DEFAULT-NEXT:    store i32 [[TMP2]], ptr [[DST]], align 4
; DEFAULT-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 8
; DEFAULT-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[STEP_ADD]], splat (i64 4)
; DEFAULT-NEXT:    [[TMP3:%.*]] = icmp eq i64 [[INDEX_NEXT]], 16
; DEFAULT-NEXT:    br i1 [[TMP3]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP28:![0-9]+]]
; DEFAULT:       [[MIDDLE_BLOCK]]:
; DEFAULT-NEXT:    br i1 false, label %[[EXIT:.*]], label %[[SCALAR_PH]]
; DEFAULT:       [[SCALAR_PH]]:
; DEFAULT-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 16, %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; DEFAULT-NEXT:    br label %[[LOOP_HEADER:.*]]
; DEFAULT:       [[LOOP_HEADER]]:
; DEFAULT-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; DEFAULT-NEXT:    br i1 [[C]], label %[[LOOP_LATCH]], label %[[THEN:.*]]
; DEFAULT:       [[THEN]]:
; DEFAULT-NEXT:    br label %[[LOOP_LATCH]]
; DEFAULT:       [[LOOP_LATCH]]:
; DEFAULT-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; DEFAULT-NEXT:    [[T:%.*]] = trunc nuw nsw i64 [[IV_NEXT]] to i32
; DEFAULT-NEXT:    store i32 [[T]], ptr [[DST]], align 4
; DEFAULT-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], 21
; DEFAULT-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP_HEADER]], !llvm.loop [[LOOP29:![0-9]+]]
; DEFAULT:       [[EXIT]]:
; DEFAULT-NEXT:    ret void
;
; PRED-LABEL: define void @redundant_branch_and_tail_folding(
; PRED-SAME: ptr [[DST:%.*]], i1 [[C:%.*]]) {
; PRED-NEXT:  [[ENTRY:.*]]:
; PRED-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; PRED:       [[VECTOR_PH]]:
; PRED-NEXT:    br label %[[VECTOR_BODY:.*]]
; PRED:       [[VECTOR_BODY]]:
; PRED-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[PRED_STORE_CONTINUE6:.*]] ]
; PRED-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[PRED_STORE_CONTINUE6]] ]
; PRED-NEXT:    [[TMP0:%.*]] = icmp ule <4 x i64> [[VEC_IND]], splat (i64 20)
; PRED-NEXT:    [[TMP1:%.*]] = add nuw nsw <4 x i64> [[VEC_IND]], splat (i64 1)
; PRED-NEXT:    [[TMP2:%.*]] = trunc nuw nsw <4 x i64> [[TMP1]] to <4 x i32>
; PRED-NEXT:    [[TMP3:%.*]] = extractelement <4 x i1> [[TMP0]], i32 0
; PRED-NEXT:    br i1 [[TMP3]], label %[[PRED_STORE_IF:.*]], label %[[PRED_STORE_CONTINUE:.*]]
; PRED:       [[PRED_STORE_IF]]:
; PRED-NEXT:    [[TMP4:%.*]] = extractelement <4 x i32> [[TMP2]], i32 0
; PRED-NEXT:    store i32 [[TMP4]], ptr [[DST]], align 4
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE]]
; PRED:       [[PRED_STORE_CONTINUE]]:
; PRED-NEXT:    [[TMP5:%.*]] = extractelement <4 x i1> [[TMP0]], i32 1
; PRED-NEXT:    br i1 [[TMP5]], label %[[PRED_STORE_IF1:.*]], label %[[PRED_STORE_CONTINUE2:.*]]
; PRED:       [[PRED_STORE_IF1]]:
; PRED-NEXT:    [[TMP6:%.*]] = extractelement <4 x i32> [[TMP2]], i32 1
; PRED-NEXT:    store i32 [[TMP6]], ptr [[DST]], align 4
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE2]]
; PRED:       [[PRED_STORE_CONTINUE2]]:
; PRED-NEXT:    [[TMP7:%.*]] = extractelement <4 x i1> [[TMP0]], i32 2
; PRED-NEXT:    br i1 [[TMP7]], label %[[PRED_STORE_IF3:.*]], label %[[PRED_STORE_CONTINUE4:.*]]
; PRED:       [[PRED_STORE_IF3]]:
; PRED-NEXT:    [[TMP8:%.*]] = extractelement <4 x i32> [[TMP2]], i32 2
; PRED-NEXT:    store i32 [[TMP8]], ptr [[DST]], align 4
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE4]]
; PRED:       [[PRED_STORE_CONTINUE4]]:
; PRED-NEXT:    [[TMP9:%.*]] = extractelement <4 x i1> [[TMP0]], i32 3
; PRED-NEXT:    br i1 [[TMP9]], label %[[PRED_STORE_IF5:.*]], label %[[PRED_STORE_CONTINUE6]]
; PRED:       [[PRED_STORE_IF5]]:
; PRED-NEXT:    [[TMP10:%.*]] = extractelement <4 x i32> [[TMP2]], i32 3
; PRED-NEXT:    store i32 [[TMP10]], ptr [[DST]], align 4
; PRED-NEXT:    br label %[[PRED_STORE_CONTINUE6]]
; PRED:       [[PRED_STORE_CONTINUE6]]:
; PRED-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; PRED-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], splat (i64 4)
; PRED-NEXT:    [[TMP11:%.*]] = icmp eq i64 [[INDEX_NEXT]], 24
; PRED-NEXT:    br i1 [[TMP11]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP10:![0-9]+]]
; PRED:       [[MIDDLE_BLOCK]]:
; PRED-NEXT:    br label %[[EXIT:.*]]
; PRED:       [[SCALAR_PH]]:
; PRED-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 0, %[[ENTRY]] ]
; PRED-NEXT:    br label %[[LOOP_HEADER:.*]]
; PRED:       [[LOOP_HEADER]]:
; PRED-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; PRED-NEXT:    br i1 [[C]], label %[[LOOP_LATCH]], label %[[THEN:.*]]
; PRED:       [[THEN]]:
; PRED-NEXT:    br label %[[LOOP_LATCH]]
; PRED:       [[LOOP_LATCH]]:
; PRED-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; PRED-NEXT:    [[T:%.*]] = trunc nuw nsw i64 [[IV_NEXT]] to i32
; PRED-NEXT:    store i32 [[T]], ptr [[DST]], align 4
; PRED-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], 21
; PRED-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP_HEADER]], !llvm.loop [[LOOP11:![0-9]+]]
; PRED:       [[EXIT]]:
; PRED-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop.latch ]
  br i1 %c, label %loop.latch, label %then

then:
  br label %loop.latch

loop.latch:
  %iv.next = add nuw nsw i64 %iv, 1
  %t = trunc nuw nsw i64 %iv.next to i32
  store i32 %t, ptr %dst, align 4
  %ec = icmp eq i64 %iv.next, 21
  br i1 %ec, label %exit, label %loop.header

exit:
  ret void
}

; Function Attrs: nocallback nofree nosync nounwind speculatable willreturn memory(none)
declare float @llvm.fmuladd.f32(float, float, float) #1

attributes #1 = { "target-cpu"="neoverse-512tvb" }
attributes #2 = { vscale_range(2,2) "target-cpu"="neoverse-512tvb" }

!0 = distinct !{!0, !1, !2, !3}
!1 = !{!"llvm.loop.vectorize.width", i32 8}
!2 = !{!"llvm.loop.vectorize.scalable.enable", i1 false}
!3 = !{!"llvm.loop.vectorize.enable", i1 true}
