; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -mtriple=amdgcn -loop-reduce -S < %s | FileCheck %s
; REQUIRES: asserts

; Test that LSR does not attempt to extend a pointer type to an integer type,
; which causes a SCEV analysis assertion.

@gVar = external hidden local_unnamed_addr addrspace(3) global [1024 x double], align 16

define amdgpu_kernel void @scaledregtest() local_unnamed_addr {
; CHECK-LABEL: @scaledregtest(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       loopexit:
; CHECK-NEXT:    [[SCEVGEP11_LCSSA:%.*]] = phi ptr addrspace(5) [ [[SCEVGEP11:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[SCEVGEP13_LCSSA:%.*]] = phi ptr [ [[SCEVGEP13:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    br label [[FOR_BODY_1:%.*]]
; CHECK:       for.body.1:
; CHECK-NEXT:    [[LSR_IV5:%.*]] = phi ptr addrspace(5) [ [[SCEVGEP6:%.*]], [[FOR_BODY_1]] ], [ [[SCEVGEP11_LCSSA]], [[LOOPEXIT:%.*]] ]
; CHECK-NEXT:    [[LSR_IV1:%.*]] = phi ptr [ [[SCEVGEP2:%.*]], [[FOR_BODY_1]] ], [ [[SCEVGEP13_LCSSA]], [[LOOPEXIT]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr addrspace(5) [[LSR_IV5]], align 8
; CHECK-NEXT:    store ptr [[TMP0]], ptr [[LSR_IV1]], align 8
; CHECK-NEXT:    [[SCEVGEP2]] = getelementptr i8, ptr [[LSR_IV1]], i64 8
; CHECK-NEXT:    [[SCEVGEP6]] = getelementptr i8, ptr addrspace(5) [[LSR_IV5]], i32 8
; CHECK-NEXT:    br label [[FOR_BODY_1]]
; CHECK:       for.body:
; CHECK-NEXT:    [[LSR_IV12:%.*]] = phi ptr [ [[SCEVGEP13]], [[FOR_BODY]] ], [ null, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[LSR_IV10:%.*]] = phi ptr addrspace(5) [ [[SCEVGEP11]], [[FOR_BODY]] ], [ null, [[ENTRY]] ]
; CHECK-NEXT:    [[SCEVGEP11]] = getelementptr i8, ptr addrspace(5) [[LSR_IV10]], i32 64
; CHECK-NEXT:    [[SCEVGEP13]] = getelementptr i8, ptr [[LSR_IV12]], i64 64
; CHECK-NEXT:    br i1 false, label [[LOOPEXIT]], label [[FOR_BODY]]
;
entry:
  br label %for.body

loopexit:
  %conv = zext i32 %inc to i64
  br label %for.body.1

for.body.1:
  %conv.1 = phi i64 [ %conv.2, %for.body.1 ], [ %conv, %loopexit ]
  %I.1 = phi i32 [ %inc.1, %for.body.1 ], [ %inc, %loopexit ]
  %idxprom = trunc i64 %conv.1 to i32
  %arrayidx = getelementptr inbounds ptr, ptr addrspace(5) null, i32 %idxprom
  %0 = load ptr, ptr addrspace(5) %arrayidx, align 8
  %arrayidx.1 = getelementptr inbounds ptr, ptr null, i64 %conv.1
  store ptr %0, ptr %arrayidx.1, align 8
  %inc.1 = add nuw nsw i32 %I.1, 1
  %conv.2 = zext i32 %inc.1 to i64
  br label %for.body.1

for.body:
  %I = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %I, 8
  br i1 false, label %loopexit, label %for.body
}

define protected amdgpu_kernel void @baseregtest(i32 %n, i32 %lda, i1 %arg) local_unnamed_addr {
; CHECK-LABEL: @baseregtest(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 %arg, label [[EXIT:%.*]], label [[IF_END:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    [[TMP0:%.*]] = tail call i32 @foo()
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[TMP0]], 3
; CHECK-NEXT:    [[SCEVGEP:%.*]] = getelementptr i8, ptr addrspace(3) @gVar, i32 [[TMP1]]
; CHECK-NEXT:    [[TMP2:%.*]] = shl i32 [[N:%.*]], 3
; CHECK-NEXT:    [[TMP3:%.*]] = sext i32 [[TMP0]] to i64
; CHECK-NEXT:    [[TMP4:%.*]] = shl nsw i64 [[TMP3]], 3
; CHECK-NEXT:    [[SCEVGEP2:%.*]] = getelementptr i8, ptr addrspace(1) null, i64 [[TMP4]]
; CHECK-NEXT:    [[TMP5:%.*]] = sext i32 [[LDA:%.*]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = shl nsw i64 [[TMP5]], 3
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[LSR_IV3:%.*]] = phi ptr addrspace(1) [ [[SCEVGEP4:%.*]], [[FOR_BODY]] ], [ [[SCEVGEP2]], [[IF_END]] ]
; CHECK-NEXT:    [[LSR_IV:%.*]] = phi ptr addrspace(3) [ [[SCEVGEP1:%.*]], [[FOR_BODY]] ], [ [[SCEVGEP]], [[IF_END]] ]
; CHECK-NEXT:    [[TMP7:%.*]] = load double, ptr addrspace(1) [[LSR_IV3]], align 8
; CHECK-NEXT:    store double [[TMP7]], ptr addrspace(3) [[LSR_IV]], align 8
; CHECK-NEXT:    [[SCEVGEP1]] = getelementptr i8, ptr addrspace(3) [[LSR_IV]], i32 [[TMP2]]
; CHECK-NEXT:    [[SCEVGEP4]] = getelementptr i8, ptr addrspace(1) [[LSR_IV3]], i64 [[TMP6]]
; CHECK-NEXT:    br label [[FOR_BODY]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br i1 %arg, label %exit, label %if.end

if.end:
  %0 = tail call i32 @foo()
  br label %for.body

for.body:
  %i = phi i32 [ %inc, %for.body ], [ 0, %if.end ]
  %mul1 = mul nsw i32 %i, %lda
  %add1 = add nsw i32 %mul1, %0
  %idxprom = sext i32 %add1 to i64
  %arrayidx = getelementptr inbounds double, ptr addrspace(1) null, i64 %idxprom
  %1 = load double, ptr addrspace(1) %arrayidx, align 8
  %mul2 = mul nsw i32 %i, %n
  %add2 = add nsw i32 %mul2, %0
  %arrayidx9110 = getelementptr inbounds [1024 x double], ptr addrspace(3) @gVar, i32 0, i32 %add2
  store double %1, ptr addrspace(3) %arrayidx9110, align 8
  %inc = add nuw nsw i32 %i, 1
  br label %for.body

exit:
  ret void
}

declare i32 @foo()
