; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

define <2 x i1> @icmp_eq_zext_is_false(<2 x i8> %x) {
; CHECK-LABEL: @icmp_eq_zext_is_false(
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %xext = zext <2 x i8> %x to <2 x i32>
  %cmp = icmp eq <2 x i32> %xext, <i32 511, i32 1234>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_ugt_zext_is_false(<2 x i8> %x) {
; CHECK-LABEL: @icmp_ugt_zext_is_false(
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %xext = zext <2 x i8> %x to <2 x i32>
  %cmp = icmp ugt <2 x i32> %xext, <i32 256, i32 1234>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_ugt_zext_todo_off_by1(<2 x i8> %x) {
; CHECK-LABEL: @icmp_ugt_zext_todo_off_by1(
; CHECK-NEXT:    [[XEXT:%.*]] = zext <2 x i8> [[X:%.*]] to <2 x i32>
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt <2 x i32> [[XEXT]], <i32 1234, i32 255>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %xext = zext <2 x i8> %x to <2 x i32>
  %cmp = icmp ugt <2 x i32> %xext, <i32 1234, i32 255>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_uge_zext_is_false(<2 x i8> %x) {
; CHECK-LABEL: @icmp_uge_zext_is_false(
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %xext = zext <2 x i8> %x to <2 x i32>
  %cmp = icmp uge <2 x i32> %xext, <i32 256, i32 1234>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_eq_zext_fail(<2 x i8> %x) {
; CHECK-LABEL: @icmp_eq_zext_fail(
; CHECK-NEXT:    [[XEXT:%.*]] = zext <2 x i8> [[X:%.*]] to <2 x i32>
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i32> [[XEXT]], <i32 511, i32 123>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %xext = zext <2 x i8> %x to <2 x i32>
  %cmp = icmp eq <2 x i32> %xext, <i32 511, i32 123>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_eq_zext_unused(<2 x i8> %x) {
; CHECK-LABEL: @icmp_eq_zext_unused(
; CHECK-NEXT:    [[XEXT:%.*]] = zext <2 x i8> [[X:%.*]] to <2 x i32>
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i32> [[XEXT]], <i32 254, i32 123>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %xext = zext <2 x i8> %x to <2 x i32>
  %cmp = icmp eq <2 x i32> %xext, <i32 254, i32 123>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_ne_zext_is_true(<2 x i8> %x) {
; CHECK-LABEL: @icmp_ne_zext_is_true(
; CHECK-NEXT:    ret <2 x i1> splat (i1 true)
;
  %xext = zext <2 x i8> %x to <2 x i32>
  %cmp = icmp ne <2 x i32> %xext, <i32 256, i32 1234>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_ult_zext_is_true(<2 x i8> %x) {
; CHECK-LABEL: @icmp_ult_zext_is_true(
; CHECK-NEXT:    ret <2 x i1> splat (i1 true)
;
  %xext = zext <2 x i8> %x to <2 x i32>
  %cmp = icmp ult <2 x i32> %xext, <i32 256, i32 1234>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_ule_zext_is_true(<2 x i8> %x) {
; CHECK-LABEL: @icmp_ule_zext_is_true(
; CHECK-NEXT:    ret <2 x i1> splat (i1 true)
;
  %xext = zext <2 x i8> %x to <2 x i32>
  %cmp = icmp ule <2 x i32> %xext, <i32 256, i32 -1>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_ne_zext_fail(<2 x i8> %x) {
; CHECK-LABEL: @icmp_ne_zext_fail(
; CHECK-NEXT:    [[XEXT:%.*]] = zext <2 x i8> [[X:%.*]] to <2 x i32>
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i32> [[XEXT]], <i32 256, i32 123>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %xext = zext <2 x i8> %x to <2 x i32>
  %cmp = icmp ne <2 x i32> %xext, <i32 256, i32 123>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_ne_zext_unused(<2 x i8> %x) {
; CHECK-LABEL: @icmp_ne_zext_unused(
; CHECK-NEXT:    [[XEXT:%.*]] = zext <2 x i8> [[X:%.*]] to <2 x i32>
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i32> [[XEXT]], <i32 1, i32 123>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %xext = zext <2 x i8> %x to <2 x i32>
  %cmp = icmp ne <2 x i32> %xext, <i32 1, i32 123>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_sge_zext_is_false_true(<2 x i8> %x) {
; CHECK-LABEL: @icmp_sge_zext_is_false_true(
; CHECK-NEXT:    ret <2 x i1> <i1 false, i1 true>
;
  %xext = zext <2 x i8> %x to <2 x i32>
  %cmp = icmp sge <2 x i32> %xext, <i32 257, i32 -450>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_sle_zext_is_false_false(<2 x i8> %x) {
; CHECK-LABEL: @icmp_sle_zext_is_false_false(
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %xext = zext <2 x i8> %x to <2 x i32>
  %cmp = icmp sle <2 x i32> %xext, <i32 -256, i32 -450>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_eq_sext_is_false(<2 x i8> %x) {
; CHECK-LABEL: @icmp_eq_sext_is_false(
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %xext = sext <2 x i8> %x to <2 x i32>
  %cmp = icmp eq <2 x i32> %xext, <i32 255, i32 129>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_eq_sext_fail(<2 x i8> %x) {
; CHECK-LABEL: @icmp_eq_sext_fail(
; CHECK-NEXT:    [[XEXT:%.*]] = sext <2 x i8> [[X:%.*]] to <2 x i32>
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i32> [[XEXT]], <i32 255, i32 -1>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %xext = sext <2 x i8> %x to <2 x i32>
  %cmp = icmp eq <2 x i32> %xext, <i32 255, i32 -1>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_ne_sext_is_true(<2 x i8> %x) {
; CHECK-LABEL: @icmp_ne_sext_is_true(
; CHECK-NEXT:    ret <2 x i1> splat (i1 true)
;
  %xext = sext <2 x i8> %x to <2 x i32>
  %cmp = icmp ne <2 x i32> %xext, <i32 199, i32 1234>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_sgt_sext_is_true_false(<2 x i8> %x) {
; CHECK-LABEL: @icmp_sgt_sext_is_true_false(
; CHECK-NEXT:    ret <2 x i1> <i1 true, i1 false>
;
  %xext = sext <2 x i8> %x to <2 x i32>
  %cmp = icmp sgt <2 x i32> %xext, <i32 -250, i32 450>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_slt_sext_is_true_false(<2 x i8> %x) {
; CHECK-LABEL: @icmp_slt_sext_is_true_false(
; CHECK-NEXT:    ret <2 x i1> <i1 true, i1 false>
;
  %xext = sext <2 x i8> %x to <2 x i32>
  %cmp = icmp slt <2 x i32> %xext, <i32 257, i32 -450>
  ret <2 x i1> %cmp
}

define <vscale x 4 x i1> @icmp_ult_sext_scalable_splat_is_true(<vscale x 4 x i8> %x) {
; CHECK-LABEL: @icmp_ult_sext_scalable_splat_is_true(
; CHECK-NEXT:    ret <vscale x 4 x i1> splat (i1 true)
;
  %s = sext <vscale x 4 x i8> %x to <vscale x 4 x i64>
  %cmp = icmp slt <vscale x 4 x i64> %s, splat (i64 257)
  ret <vscale x 4 x i1> %cmp
}
