; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=riscv32 -mattr=+f,+experimental-xqccmp -target-abi ilp32f -verify-machineinstrs < %s | FileCheck %s --check-prefix=XQCCMP32
; RUN: llc -mtriple=riscv64 -mattr=+f,+experimental-xqccmp -target-abi lp64f -verify-machineinstrs < %s | FileCheck %s --check-prefix=XQCCMP64

declare void @callee()

; Test the file could be compiled successfully.
define float @foo(float %arg) {
; XQCCMP32-LABEL: foo:
; XQCCMP32:       # %bb.0: # %entry
; XQCCMP32-NEXT:    qc.cm.push {ra}, -32
; XQCCMP32-NEXT:    .cfi_def_cfa_offset 32
; XQCCMP32-NEXT:    .cfi_offset ra, -4
; XQCCMP32-NEXT:    fsw fs0, 12(sp) # 4-byte Folded Spill
; XQCCMP32-NEXT:    .cfi_offset fs0, -20
; XQCCMP32-NEXT:    fmv.s fs0, fa0
; XQCCMP32-NEXT:    call callee
; XQCCMP32-NEXT:    fmv.s fa0, fs0
; XQCCMP32-NEXT:    flw fs0, 12(sp) # 4-byte Folded Reload
; XQCCMP32-NEXT:    .cfi_restore fs0
; XQCCMP32-NEXT:    qc.cm.popret {ra}, 32
;
; XQCCMP64-LABEL: foo:
; XQCCMP64:       # %bb.0: # %entry
; XQCCMP64-NEXT:    qc.cm.push {ra}, -32
; XQCCMP64-NEXT:    .cfi_def_cfa_offset 32
; XQCCMP64-NEXT:    .cfi_offset ra, -8
; XQCCMP64-NEXT:    fsw fs0, 12(sp) # 4-byte Folded Spill
; XQCCMP64-NEXT:    .cfi_offset fs0, -20
; XQCCMP64-NEXT:    fmv.s fs0, fa0
; XQCCMP64-NEXT:    call callee
; XQCCMP64-NEXT:    fmv.s fa0, fs0
; XQCCMP64-NEXT:    flw fs0, 12(sp) # 4-byte Folded Reload
; XQCCMP64-NEXT:    .cfi_restore fs0
; XQCCMP64-NEXT:    qc.cm.popret {ra}, 32
entry:
  call void @callee()
  ret float %arg
}

define void @foo2(i32 %x, float %y) {
; XQCCMP32-LABEL: foo2:
; XQCCMP32:       # %bb.0: # %entry
; XQCCMP32-NEXT:    qc.cm.push {ra, s0}, -32
; XQCCMP32-NEXT:    .cfi_def_cfa_offset 32
; XQCCMP32-NEXT:    .cfi_offset ra, -4
; XQCCMP32-NEXT:    .cfi_offset s0, -8
; XQCCMP32-NEXT:    fsw fs0, 12(sp) # 4-byte Folded Spill
; XQCCMP32-NEXT:    .cfi_offset fs0, -20
; XQCCMP32-NEXT:    fmv.s fs0, fa0
; XQCCMP32-NEXT:    mv s0, a0
; XQCCMP32-NEXT:    call bar
; XQCCMP32-NEXT:    mv a0, s0
; XQCCMP32-NEXT:    fmv.s fa0, fs0
; XQCCMP32-NEXT:    flw fs0, 12(sp) # 4-byte Folded Reload
; XQCCMP32-NEXT:    .cfi_restore fs0
; XQCCMP32-NEXT:    qc.cm.pop {ra, s0}, 32
; XQCCMP32-NEXT:    .cfi_restore ra
; XQCCMP32-NEXT:    .cfi_restore s0
; XQCCMP32-NEXT:    .cfi_def_cfa_offset 0
; XQCCMP32-NEXT:    tail func
;
; XQCCMP64-LABEL: foo2:
; XQCCMP64:       # %bb.0: # %entry
; XQCCMP64-NEXT:    qc.cm.push {ra, s0}, -32
; XQCCMP64-NEXT:    .cfi_def_cfa_offset 32
; XQCCMP64-NEXT:    .cfi_offset ra, -8
; XQCCMP64-NEXT:    .cfi_offset s0, -16
; XQCCMP64-NEXT:    fsw fs0, 12(sp) # 4-byte Folded Spill
; XQCCMP64-NEXT:    .cfi_offset fs0, -20
; XQCCMP64-NEXT:    fmv.s fs0, fa0
; XQCCMP64-NEXT:    mv s0, a0
; XQCCMP64-NEXT:    call bar
; XQCCMP64-NEXT:    mv a0, s0
; XQCCMP64-NEXT:    fmv.s fa0, fs0
; XQCCMP64-NEXT:    flw fs0, 12(sp) # 4-byte Folded Reload
; XQCCMP64-NEXT:    .cfi_restore fs0
; XQCCMP64-NEXT:    qc.cm.pop {ra, s0}, 32
; XQCCMP64-NEXT:    .cfi_restore ra
; XQCCMP64-NEXT:    .cfi_restore s0
; XQCCMP64-NEXT:    .cfi_def_cfa_offset 0
; XQCCMP64-NEXT:    tail func
entry:
  tail call void @bar()
  tail call void @func(i32 %x, float %y)
  ret void
}

declare void @bar()
declare void @func(i32, float)
