; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 -mattr=+d --verify-machineinstrs < %s \
; RUN:   | FileCheck --check-prefix=LA32 %s
; RUN: llc --mtriple=loongarch64 -mattr=+d --verify-machineinstrs < %s \
; RUN:   | FileCheck --check-prefix=LA64 %s

;; These test that we can use architectural names ($r*) refer to registers in
;; inline asm constraint lists. In each case, the named register should be used
;; for the source register of the `addi.w`. It is very likely that `$a0` will
;; be chosen as the designation register, but this is left to the compiler to
;; choose.
;;
;; Parenthesised registers in comments are the other aliases for this register.

;; NOTE: This test has to pass in 0 to the inline asm, because that's the only
;; value `$r0` (`$zero`) can take.
define i32 @register_r0() nounwind {
; LA32-LABEL: register_r0:
; LA32:       # %bb.0:
; LA32-NEXT:    #APP
; LA32-NEXT:    addi.w $a0, $zero, 0
; LA32-NEXT:    #NO_APP
; LA32-NEXT:    ret
;
; LA64-LABEL: register_r0:
; LA64:       # %bb.0:
; LA64-NEXT:    #APP
; LA64-NEXT:    addi.w $a0, $zero, 0
; LA64-NEXT:    #NO_APP
; LA64-NEXT:    ret
  %1 = tail call i32 asm "addi.w $0, $1, 0", "=r,{$r0}"(i32 0)
  ret i32 %1
}

define i32 @register_r4(i32 %a) nounwind {
; LA32-LABEL: register_r4:
; LA32:       # %bb.0:
; LA32-NEXT:    #APP
; LA32-NEXT:    addi.w $a0, $a0, 1
; LA32-NEXT:    #NO_APP
; LA32-NEXT:    ret
;
; LA64-LABEL: register_r4:
; LA64:       # %bb.0:
; LA64-NEXT:    #APP
; LA64-NEXT:    addi.w $a0, $a0, 1
; LA64-NEXT:    #NO_APP
; LA64-NEXT:    ret
  %1 = tail call i32 asm "addi.w $0, $1, 1", "=r,{$r4}"(i32 %a)
  ret i32 %1
}

;; NOTE: This test uses `$r22` (`$s9`, `$fp`) as an input, so it should be saved.
define i32 @register_r22(i32 %a) nounwind {
; LA32-LABEL: register_r22:
; LA32:       # %bb.0:
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $fp, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    move $fp, $a0
; LA32-NEXT:    #APP
; LA32-NEXT:    addi.w $a0, $fp, 1
; LA32-NEXT:    #NO_APP
; LA32-NEXT:    ld.w $fp, $sp, 12 # 4-byte Folded Reload
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: register_r22:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $fp, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    move $fp, $a0
; LA64-NEXT:    #APP
; LA64-NEXT:    addi.w $a0, $fp, 1
; LA64-NEXT:    #NO_APP
; LA64-NEXT:    ld.d $fp, $sp, 8 # 8-byte Folded Reload
; LA64-NEXT:    addi.d $sp, $sp, 16
; LA64-NEXT:    ret
  %1 = tail call i32 asm "addi.w $0, $1, 1", "=r,{$r22}"(i32 %a)
  ret i32 %1
}

;; NOTE: This test uses `$r31` (`$s8`) as an input, so it should be saved.
define i32 @register_r31(i32 %a) nounwind {
; LA32-LABEL: register_r31:
; LA32:       # %bb.0:
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $s8, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    move $s8, $a0
; LA32-NEXT:    #APP
; LA32-NEXT:    addi.w $a0, $s8, 1
; LA32-NEXT:    #NO_APP
; LA32-NEXT:    ld.w $s8, $sp, 12 # 4-byte Folded Reload
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: register_r31:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $s8, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    move $s8, $a0
; LA64-NEXT:    #APP
; LA64-NEXT:    addi.w $a0, $s8, 1
; LA64-NEXT:    #NO_APP
; LA64-NEXT:    ld.d $s8, $sp, 8 # 8-byte Folded Reload
; LA64-NEXT:    addi.d $sp, $sp, 16
; LA64-NEXT:    ret
  %1 = tail call i32 asm "addi.w $0, $1, 1", "=r,{$r31}"(i32 %a)
  ret i32 %1
}
