; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test i128 minimum on z13.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

; Test with slt.
define i128 @f1(i128 %val1, i128 %val2) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vecg %v0, %v1
; CHECK-NEXT:    je .LBB0_3
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    jnl .LBB0_4
; CHECK-NEXT:  .LBB0_2:
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
; CHECK-NEXT:  .LBB0_3:
; CHECK-NEXT:    vchlgs %v2, %v1, %v0
; CHECK-NEXT:    jl .LBB0_2
; CHECK-NEXT:  .LBB0_4:
; CHECK-NEXT:    vlr %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp slt i128 %val2, %val1
  %ret = select i1 %cmp, i128 %val2, i128 %val1
  ret i128 %ret
}

; Test with sle.
define i128 @f2(i128 %val1, i128 %val2) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vecg %v1, %v0
; CHECK-NEXT:    je .LBB1_3
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    jl .LBB1_4
; CHECK-NEXT:  .LBB1_2:
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
; CHECK-NEXT:  .LBB1_3:
; CHECK-NEXT:    vchlgs %v2, %v0, %v1
; CHECK-NEXT:    jnl .LBB1_2
; CHECK-NEXT:  .LBB1_4:
; CHECK-NEXT:    vlr %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp sle i128 %val2, %val1
  %ret = select i1 %cmp, i128 %val2, i128 %val1
  ret i128 %ret
}

; Test with sgt.
define i128 @f3(i128 %val1, i128 %val2) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vecg %v0, %v1
; CHECK-NEXT:    je .LBB2_3
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    jnl .LBB2_4
; CHECK-NEXT:  .LBB2_2:
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
; CHECK-NEXT:  .LBB2_3:
; CHECK-NEXT:    vchlgs %v2, %v1, %v0
; CHECK-NEXT:    jl .LBB2_2
; CHECK-NEXT:  .LBB2_4:
; CHECK-NEXT:    vlr %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp sgt i128 %val2, %val1
  %ret = select i1 %cmp, i128 %val1, i128 %val2
  ret i128 %ret
}

; Test with sge.
define i128 @f4(i128 %val1, i128 %val2) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vecg %v1, %v0
; CHECK-NEXT:    je .LBB3_3
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    jl .LBB3_4
; CHECK-NEXT:  .LBB3_2:
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
; CHECK-NEXT:  .LBB3_3:
; CHECK-NEXT:    vchlgs %v2, %v0, %v1
; CHECK-NEXT:    jnl .LBB3_2
; CHECK-NEXT:  .LBB3_4:
; CHECK-NEXT:    vlr %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp sge i128 %val2, %val1
  %ret = select i1 %cmp, i128 %val1, i128 %val2
  ret i128 %ret
}

; Test with ult.
define i128 @f5(i128 %val1, i128 %val2) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    veclg %v0, %v1
; CHECK-NEXT:    je .LBB4_3
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    jnl .LBB4_4
; CHECK-NEXT:  .LBB4_2:
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
; CHECK-NEXT:  .LBB4_3:
; CHECK-NEXT:    vchlgs %v2, %v1, %v0
; CHECK-NEXT:    jl .LBB4_2
; CHECK-NEXT:  .LBB4_4:
; CHECK-NEXT:    vlr %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp ult i128 %val2, %val1
  %ret = select i1 %cmp, i128 %val2, i128 %val1
  ret i128 %ret
}

; Test with ule.
define i128 @f6(i128 %val1, i128 %val2) {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    veclg %v1, %v0
; CHECK-NEXT:    je .LBB5_3
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    jl .LBB5_4
; CHECK-NEXT:  .LBB5_2:
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
; CHECK-NEXT:  .LBB5_3:
; CHECK-NEXT:    vchlgs %v2, %v0, %v1
; CHECK-NEXT:    jnl .LBB5_2
; CHECK-NEXT:  .LBB5_4:
; CHECK-NEXT:    vlr %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp ule i128 %val2, %val1
  %ret = select i1 %cmp, i128 %val2, i128 %val1
  ret i128 %ret
}

; Test with ugt.
define i128 @f7(i128 %val1, i128 %val2) {
; CHECK-LABEL: f7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    veclg %v0, %v1
; CHECK-NEXT:    je .LBB6_3
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    jnl .LBB6_4
; CHECK-NEXT:  .LBB6_2:
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
; CHECK-NEXT:  .LBB6_3:
; CHECK-NEXT:    vchlgs %v2, %v1, %v0
; CHECK-NEXT:    jl .LBB6_2
; CHECK-NEXT:  .LBB6_4:
; CHECK-NEXT:    vlr %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp ugt i128 %val2, %val1
  %ret = select i1 %cmp, i128 %val1, i128 %val2
  ret i128 %ret
}

; Test with uge.
define i128 @f8(i128 %val1, i128 %val2) {
; CHECK-LABEL: f8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    veclg %v1, %v0
; CHECK-NEXT:    je .LBB7_3
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    jl .LBB7_4
; CHECK-NEXT:  .LBB7_2:
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
; CHECK-NEXT:  .LBB7_3:
; CHECK-NEXT:    vchlgs %v2, %v0, %v1
; CHECK-NEXT:    jnl .LBB7_2
; CHECK-NEXT:  .LBB7_4:
; CHECK-NEXT:    vlr %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp uge i128 %val2, %val1
  %ret = select i1 %cmp, i128 %val1, i128 %val2
  ret i128 %ret
}
