; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zvfh,+zfbfmin,+zvfbfmin,+v -target-abi=ilp32d \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv32 -mattr=+d,+zvfh,+zfbfmin,+zvfbfmin,+v -target-abi=ilp32d \
; RUN:   -verify-machineinstrs -early-live-intervals < %s | FileCheck %s --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv64 -mattr=+d,+zvfh,+zfbfmin,+zvfbfmin,+v -target-abi=lp64d \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv64 -mattr=+d,+zvfh,+zfbfmin,+zvfbfmin,+v -target-abi=lp64d \
; RUN:   -verify-machineinstrs -early-live-intervals < %s | FileCheck %s --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv32 -mattr=+d,+zvfhmin,+zfbfmin,+zvfbfmin,+v,+m -target-abi=ilp32d \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFHMIN
; RUN: llc -mtriple=riscv32 -mattr=+d,+zvfhmin,+zfbfmin,+zvfbfmin,+v,+m -target-abi=ilp32d \
; RUN:   -verify-machineinstrs -early-live-intervals < %s | FileCheck %s --check-prefixes=CHECK,ZVFHMIN
; RUN: llc -mtriple=riscv64 -mattr=+d,+zvfhmin,+zfbfmin,+zvfbfmin,+v,+m -target-abi=lp64d \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFHMIN
; RUN: llc -mtriple=riscv64 -mattr=+d,+zvfhmin,+zfbfmin,+zvfbfmin,+v,+m -target-abi=lp64d \
; RUN:   -verify-machineinstrs -early-live-intervals < %s | FileCheck %s --check-prefixes=CHECK,ZVFHMIN

declare <vscale x 1 x bfloat> @llvm.minimum.nxv1bf16(<vscale x 1 x bfloat>, <vscale x 1 x bfloat>)

define <vscale x 1 x bfloat> @vfmin_nxv1bf16_vv(<vscale x 1 x bfloat> %a, <vscale x 1 x bfloat> %b) {
; CHECK-LABEL: vfmin_nxv1bf16_vv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v10, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmerge.vvm v9, v10, v8, v0
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vmerge.vvm v8, v8, v10, v0
; CHECK-NEXT:    vfmin.vv v9, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x bfloat> @llvm.minimum.nxv1bf16(<vscale x 1 x bfloat> %a, <vscale x 1 x bfloat> %b)
  ret <vscale x 1 x bfloat> %v
}

declare <vscale x 2 x bfloat> @llvm.minimum.nxv2bf16(<vscale x 2 x bfloat>, <vscale x 2 x bfloat>)

define <vscale x 2 x bfloat> @vfmin_nxv2bf16_vv(<vscale x 2 x bfloat> %a, <vscale x 2 x bfloat> %b) {
; CHECK-LABEL: vfmin_nxv2bf16_vv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v10, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmerge.vvm v9, v10, v8, v0
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vmerge.vvm v8, v8, v10, v0
; CHECK-NEXT:    vfmin.vv v9, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x bfloat> @llvm.minimum.nxv2bf16(<vscale x 2 x bfloat> %a, <vscale x 2 x bfloat> %b)
  ret <vscale x 2 x bfloat> %v
}

declare <vscale x 4 x bfloat> @llvm.minimum.nxv4bf16(<vscale x 4 x bfloat>, <vscale x 4 x bfloat>)

define <vscale x 4 x bfloat> @vfmin_nxv4bf16_vv(<vscale x 4 x bfloat> %a, <vscale x 4 x bfloat> %b) {
; CHECK-LABEL: vfmin_nxv4bf16_vv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v10, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmerge.vvm v8, v10, v12, v0
; CHECK-NEXT:    vmfeq.vv v0, v12, v12
; CHECK-NEXT:    vmerge.vvm v10, v12, v10, v0
; CHECK-NEXT:    vfmin.vv v10, v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x bfloat> @llvm.minimum.nxv4bf16(<vscale x 4 x bfloat> %a, <vscale x 4 x bfloat> %b)
  ret <vscale x 4 x bfloat> %v
}

declare <vscale x 8 x bfloat> @llvm.minimum.nxv8bf16(<vscale x 8 x bfloat>, <vscale x 8 x bfloat>)

define <vscale x 8 x bfloat> @vfmin_nxv8bf16_vv(<vscale x 8 x bfloat> %a, <vscale x 8 x bfloat> %b) {
; CHECK-LABEL: vfmin_nxv8bf16_vv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v12, v12
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmerge.vvm v8, v12, v16, v0
; CHECK-NEXT:    vmfeq.vv v0, v16, v16
; CHECK-NEXT:    vmerge.vvm v12, v16, v12, v0
; CHECK-NEXT:    vfmin.vv v12, v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x bfloat> @llvm.minimum.nxv8bf16(<vscale x 8 x bfloat> %a, <vscale x 8 x bfloat> %b)
  ret <vscale x 8 x bfloat> %v
}

declare <vscale x 16 x bfloat> @llvm.minimum.nxv16bf16(<vscale x 16 x bfloat>, <vscale x 16 x bfloat>)

define <vscale x 16 x bfloat> @vfmin_nxv16bf16_vv(<vscale x 16 x bfloat> %a, <vscale x 16 x bfloat> %b) {
; CHECK-LABEL: vfmin_nxv16bf16_vv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v24, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v24, v24
; CHECK-NEXT:    vmfeq.vv v7, v16, v16
; CHECK-NEXT:    vmerge.vvm v8, v24, v16, v0
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vmerge.vvm v16, v16, v24, v0
; CHECK-NEXT:    vfmin.vv v16, v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x bfloat> @llvm.minimum.nxv16bf16(<vscale x 16 x bfloat> %a, <vscale x 16 x bfloat> %b)
  ret <vscale x 16 x bfloat> %v
}

declare <vscale x 32 x bfloat> @llvm.minimum.nxv32bf16(<vscale x 32 x bfloat>, <vscale x 32 x bfloat>)

define <vscale x 32 x bfloat> @vfmin_nxv32bf16_vv(<vscale x 32 x bfloat> %a, <vscale x 32 x bfloat> %b) nounwind {
; ZVFH-LABEL: vfmin_nxv32bf16_vv:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    addi sp, sp, -16
; ZVFH-NEXT:    csrr a0, vlenb
; ZVFH-NEXT:    slli a0, a0, 3
; ZVFH-NEXT:    mv a1, a0
; ZVFH-NEXT:    slli a0, a0, 1
; ZVFH-NEXT:    add a0, a0, a1
; ZVFH-NEXT:    sub sp, sp, a0
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vmv8r.v v24, v16
; ZVFH-NEXT:    csrr a0, vlenb
; ZVFH-NEXT:    slli a0, a0, 3
; ZVFH-NEXT:    add a0, sp, a0
; ZVFH-NEXT:    addi a0, a0, 16
; ZVFH-NEXT:    vs8r.v v16, (a0) # vscale x 64-byte Folded Spill
; ZVFH-NEXT:    vmv8r.v v0, v8
; ZVFH-NEXT:    vfwcvtbf16.f.f.v v16, v24
; ZVFH-NEXT:    vfwcvtbf16.f.f.v v8, v0
; ZVFH-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFH-NEXT:    vmfeq.vv v0, v8, v8
; ZVFH-NEXT:    vmfeq.vv v3, v16, v16
; ZVFH-NEXT:    vmerge.vvm v24, v8, v16, v0
; ZVFH-NEXT:    csrr a0, vlenb
; ZVFH-NEXT:    slli a0, a0, 4
; ZVFH-NEXT:    add a0, sp, a0
; ZVFH-NEXT:    addi a0, a0, 16
; ZVFH-NEXT:    vs8r.v v24, (a0) # vscale x 64-byte Folded Spill
; ZVFH-NEXT:    vmv1r.v v0, v3
; ZVFH-NEXT:    vmerge.vvm v8, v16, v8, v0
; ZVFH-NEXT:    addi a0, sp, 16
; ZVFH-NEXT:    vs8r.v v8, (a0) # vscale x 64-byte Folded Spill
; ZVFH-NEXT:    csrr a0, vlenb
; ZVFH-NEXT:    slli a0, a0, 3
; ZVFH-NEXT:    add a0, sp, a0
; ZVFH-NEXT:    addi a0, a0, 16
; ZVFH-NEXT:    vl8r.v v8, (a0) # vscale x 64-byte Folded Reload
; ZVFH-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfwcvtbf16.f.f.v v24, v12
; ZVFH-NEXT:    vfwcvtbf16.f.f.v v8, v4
; ZVFH-NEXT:    csrr a0, vlenb
; ZVFH-NEXT:    slli a0, a0, 4
; ZVFH-NEXT:    add a0, sp, a0
; ZVFH-NEXT:    addi a0, a0, 16
; ZVFH-NEXT:    vl8r.v v16, (a0) # vscale x 64-byte Folded Reload
; ZVFH-NEXT:    addi a0, sp, 16
; ZVFH-NEXT:    vl8r.v v0, (a0) # vscale x 64-byte Folded Reload
; ZVFH-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFH-NEXT:    vfmin.vv v16, v0, v16
; ZVFH-NEXT:    csrr a0, vlenb
; ZVFH-NEXT:    slli a0, a0, 4
; ZVFH-NEXT:    add a0, sp, a0
; ZVFH-NEXT:    addi a0, a0, 16
; ZVFH-NEXT:    vs8r.v v16, (a0) # vscale x 64-byte Folded Spill
; ZVFH-NEXT:    vmfeq.vv v0, v8, v8
; ZVFH-NEXT:    vmfeq.vv v7, v24, v24
; ZVFH-NEXT:    vmerge.vvm v16, v8, v24, v0
; ZVFH-NEXT:    vmv1r.v v0, v7
; ZVFH-NEXT:    vmerge.vvm v8, v24, v8, v0
; ZVFH-NEXT:    vfmin.vv v16, v8, v16
; ZVFH-NEXT:    csrr a0, vlenb
; ZVFH-NEXT:    slli a0, a0, 4
; ZVFH-NEXT:    add a0, sp, a0
; ZVFH-NEXT:    addi a0, a0, 16
; ZVFH-NEXT:    vl8r.v v24, (a0) # vscale x 64-byte Folded Reload
; ZVFH-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfncvtbf16.f.f.w v8, v24
; ZVFH-NEXT:    vfncvtbf16.f.f.w v12, v16
; ZVFH-NEXT:    csrr a0, vlenb
; ZVFH-NEXT:    slli a0, a0, 3
; ZVFH-NEXT:    mv a1, a0
; ZVFH-NEXT:    slli a0, a0, 1
; ZVFH-NEXT:    add a0, a0, a1
; ZVFH-NEXT:    add sp, sp, a0
; ZVFH-NEXT:    addi sp, sp, 16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfmin_nxv32bf16_vv:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    addi sp, sp, -16
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    li a1, 24
; ZVFHMIN-NEXT:    mul a0, a0, a1
; ZVFHMIN-NEXT:    sub sp, sp, a0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vmv8r.v v24, v16
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 3
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vs8r.v v16, (a0) # vscale x 64-byte Folded Spill
; ZVFHMIN-NEXT:    vmv8r.v v0, v8
; ZVFHMIN-NEXT:    vfwcvtbf16.f.f.v v16, v24
; ZVFHMIN-NEXT:    vfwcvtbf16.f.f.v v8, v0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v0, v8, v8
; ZVFHMIN-NEXT:    vmfeq.vv v3, v16, v16
; ZVFHMIN-NEXT:    vmerge.vvm v24, v8, v16, v0
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 4
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vs8r.v v24, (a0) # vscale x 64-byte Folded Spill
; ZVFHMIN-NEXT:    vmv1r.v v0, v3
; ZVFHMIN-NEXT:    vmerge.vvm v8, v16, v8, v0
; ZVFHMIN-NEXT:    addi a0, sp, 16
; ZVFHMIN-NEXT:    vs8r.v v8, (a0) # vscale x 64-byte Folded Spill
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 3
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vl8r.v v8, (a0) # vscale x 64-byte Folded Reload
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvtbf16.f.f.v v24, v12
; ZVFHMIN-NEXT:    vfwcvtbf16.f.f.v v8, v4
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 4
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vl8r.v v16, (a0) # vscale x 64-byte Folded Reload
; ZVFHMIN-NEXT:    addi a0, sp, 16
; ZVFHMIN-NEXT:    vl8r.v v0, (a0) # vscale x 64-byte Folded Reload
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfmin.vv v16, v0, v16
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 4
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vs8r.v v16, (a0) # vscale x 64-byte Folded Spill
; ZVFHMIN-NEXT:    vmfeq.vv v0, v8, v8
; ZVFHMIN-NEXT:    vmfeq.vv v7, v24, v24
; ZVFHMIN-NEXT:    vmerge.vvm v16, v8, v24, v0
; ZVFHMIN-NEXT:    vmv1r.v v0, v7
; ZVFHMIN-NEXT:    vmerge.vvm v8, v24, v8, v0
; ZVFHMIN-NEXT:    vfmin.vv v16, v8, v16
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 4
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vl8r.v v24, (a0) # vscale x 64-byte Folded Reload
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvtbf16.f.f.w v8, v24
; ZVFHMIN-NEXT:    vfncvtbf16.f.f.w v12, v16
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    li a1, 24
; ZVFHMIN-NEXT:    mul a0, a0, a1
; ZVFHMIN-NEXT:    add sp, sp, a0
; ZVFHMIN-NEXT:    addi sp, sp, 16
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 32 x bfloat> @llvm.minimum.nxv32bf16(<vscale x 32 x bfloat> %a, <vscale x 32 x bfloat> %b)
  ret <vscale x 32 x bfloat> %v
}

declare <vscale x 1 x half> @llvm.minimum.nxv1f16(<vscale x 1 x half>, <vscale x 1 x half>)

define <vscale x 1 x half> @vfmin_nxv1f16_vv(<vscale x 1 x half> %a, <vscale x 1 x half> %b) {
; ZVFH-LABEL: vfmin_nxv1f16_vv:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfeq.vv v0, v8, v8
; ZVFH-NEXT:    vmerge.vvm v10, v8, v9, v0
; ZVFH-NEXT:    vmfeq.vv v0, v9, v9
; ZVFH-NEXT:    vmerge.vvm v8, v9, v8, v0
; ZVFH-NEXT:    vfmin.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfmin_nxv1f16_vv:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v0, v10, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmerge.vvm v9, v10, v8, v0
; ZVFHMIN-NEXT:    vmfeq.vv v0, v8, v8
; ZVFHMIN-NEXT:    vmerge.vvm v8, v8, v10, v0
; ZVFHMIN-NEXT:    vfmin.vv v9, v8, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x half> @llvm.minimum.nxv1f16(<vscale x 1 x half> %a, <vscale x 1 x half> %b)
  ret <vscale x 1 x half> %v
}

declare <vscale x 2 x half> @llvm.minimum.nxv2f16(<vscale x 2 x half>, <vscale x 2 x half>)

define <vscale x 2 x half> @vfmin_nxv2f16_vv(<vscale x 2 x half> %a, <vscale x 2 x half> %b) {
; ZVFH-LABEL: vfmin_nxv2f16_vv:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vmfeq.vv v0, v8, v8
; ZVFH-NEXT:    vmerge.vvm v10, v8, v9, v0
; ZVFH-NEXT:    vmfeq.vv v0, v9, v9
; ZVFH-NEXT:    vmerge.vvm v8, v9, v8, v0
; ZVFH-NEXT:    vfmin.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfmin_nxv2f16_vv:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v0, v10, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vmerge.vvm v9, v10, v8, v0
; ZVFHMIN-NEXT:    vmfeq.vv v0, v8, v8
; ZVFHMIN-NEXT:    vmerge.vvm v8, v8, v10, v0
; ZVFHMIN-NEXT:    vfmin.vv v9, v8, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 2 x half> @llvm.minimum.nxv2f16(<vscale x 2 x half> %a, <vscale x 2 x half> %b)
  ret <vscale x 2 x half> %v
}

declare <vscale x 4 x half> @llvm.minimum.nxv4f16(<vscale x 4 x half>, <vscale x 4 x half>)

define <vscale x 4 x half> @vfmin_nxv4f16_vv(<vscale x 4 x half> %a, <vscale x 4 x half> %b) {
; ZVFH-LABEL: vfmin_nxv4f16_vv:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vmfeq.vv v0, v8, v8
; ZVFH-NEXT:    vmerge.vvm v10, v8, v9, v0
; ZVFH-NEXT:    vmfeq.vv v0, v9, v9
; ZVFH-NEXT:    vmerge.vvm v8, v9, v8, v0
; ZVFH-NEXT:    vfmin.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfmin_nxv4f16_vv:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v0, v10, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmerge.vvm v8, v10, v12, v0
; ZVFHMIN-NEXT:    vmfeq.vv v0, v12, v12
; ZVFHMIN-NEXT:    vmerge.vvm v10, v12, v10, v0
; ZVFHMIN-NEXT:    vfmin.vv v10, v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 4 x half> @llvm.minimum.nxv4f16(<vscale x 4 x half> %a, <vscale x 4 x half> %b)
  ret <vscale x 4 x half> %v
}

declare <vscale x 8 x half> @llvm.minimum.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>)

define <vscale x 8 x half> @vfmin_nxv8f16_vv(<vscale x 8 x half> %a, <vscale x 8 x half> %b) {
; ZVFH-LABEL: vfmin_nxv8f16_vv:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vv v0, v8, v8
; ZVFH-NEXT:    vmerge.vvm v12, v8, v10, v0
; ZVFH-NEXT:    vmfeq.vv v0, v10, v10
; ZVFH-NEXT:    vmerge.vvm v8, v10, v8, v0
; ZVFH-NEXT:    vfmin.vv v8, v8, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfmin_nxv8f16_vv:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v0, v12, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmerge.vvm v8, v12, v16, v0
; ZVFHMIN-NEXT:    vmfeq.vv v0, v16, v16
; ZVFHMIN-NEXT:    vmerge.vvm v12, v16, v12, v0
; ZVFHMIN-NEXT:    vfmin.vv v12, v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x half> @llvm.minimum.nxv8f16(<vscale x 8 x half> %a, <vscale x 8 x half> %b)
  ret <vscale x 8 x half> %v
}

declare <vscale x 16 x half> @llvm.minimum.nxv16f16(<vscale x 16 x half>, <vscale x 16 x half>)

define <vscale x 16 x half> @vfmin_nxv16f16_vv(<vscale x 16 x half> %a, <vscale x 16 x half> %b) {
; ZVFH-LABEL: vfmin_nxv16f16_vv:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vmfeq.vv v0, v8, v8
; ZVFH-NEXT:    vmerge.vvm v16, v8, v12, v0
; ZVFH-NEXT:    vmfeq.vv v0, v12, v12
; ZVFH-NEXT:    vmerge.vvm v8, v12, v8, v0
; ZVFH-NEXT:    vfmin.vv v8, v8, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfmin_nxv16f16_vv:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v0, v24, v24
; ZVFHMIN-NEXT:    vmfeq.vv v7, v16, v16
; ZVFHMIN-NEXT:    vmerge.vvm v8, v24, v16, v0
; ZVFHMIN-NEXT:    vmv1r.v v0, v7
; ZVFHMIN-NEXT:    vmerge.vvm v16, v16, v24, v0
; ZVFHMIN-NEXT:    vfmin.vv v16, v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 16 x half> @llvm.minimum.nxv16f16(<vscale x 16 x half> %a, <vscale x 16 x half> %b)
  ret <vscale x 16 x half> %v
}

declare <vscale x 32 x half> @llvm.minimum.nxv32f16(<vscale x 32 x half>, <vscale x 32 x half>)

define <vscale x 32 x half> @vfmin_nxv32f16_vv(<vscale x 32 x half> %a, <vscale x 32 x half> %b) nounwind {
; ZVFH-LABEL: vfmin_nxv32f16_vv:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; ZVFH-NEXT:    vmfeq.vv v0, v8, v8
; ZVFH-NEXT:    vmfeq.vv v7, v16, v16
; ZVFH-NEXT:    vmerge.vvm v24, v8, v16, v0
; ZVFH-NEXT:    vmv1r.v v0, v7
; ZVFH-NEXT:    vmerge.vvm v8, v16, v8, v0
; ZVFH-NEXT:    vfmin.vv v8, v8, v24
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfmin_nxv32f16_vv:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    addi sp, sp, -16
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    li a1, 24
; ZVFHMIN-NEXT:    mul a0, a0, a1
; ZVFHMIN-NEXT:    sub sp, sp, a0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vmv8r.v v24, v16
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 3
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vs8r.v v16, (a0) # vscale x 64-byte Folded Spill
; ZVFHMIN-NEXT:    vmv8r.v v0, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v24
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v0, v8, v8
; ZVFHMIN-NEXT:    vmfeq.vv v3, v16, v16
; ZVFHMIN-NEXT:    vmerge.vvm v24, v8, v16, v0
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 4
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vs8r.v v24, (a0) # vscale x 64-byte Folded Spill
; ZVFHMIN-NEXT:    vmv1r.v v0, v3
; ZVFHMIN-NEXT:    vmerge.vvm v8, v16, v8, v0
; ZVFHMIN-NEXT:    addi a0, sp, 16
; ZVFHMIN-NEXT:    vs8r.v v8, (a0) # vscale x 64-byte Folded Spill
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 3
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vl8r.v v8, (a0) # vscale x 64-byte Folded Reload
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v4
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 4
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vl8r.v v16, (a0) # vscale x 64-byte Folded Reload
; ZVFHMIN-NEXT:    addi a0, sp, 16
; ZVFHMIN-NEXT:    vl8r.v v0, (a0) # vscale x 64-byte Folded Reload
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfmin.vv v16, v0, v16
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 4
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vs8r.v v16, (a0) # vscale x 64-byte Folded Spill
; ZVFHMIN-NEXT:    vmfeq.vv v0, v8, v8
; ZVFHMIN-NEXT:    vmfeq.vv v7, v24, v24
; ZVFHMIN-NEXT:    vmerge.vvm v16, v8, v24, v0
; ZVFHMIN-NEXT:    vmv1r.v v0, v7
; ZVFHMIN-NEXT:    vmerge.vvm v8, v24, v8, v0
; ZVFHMIN-NEXT:    vfmin.vv v16, v8, v16
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 4
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vl8r.v v24, (a0) # vscale x 64-byte Folded Reload
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v24
; ZVFHMIN-NEXT:    vfncvt.f.f.w v12, v16
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    li a1, 24
; ZVFHMIN-NEXT:    mul a0, a0, a1
; ZVFHMIN-NEXT:    add sp, sp, a0
; ZVFHMIN-NEXT:    addi sp, sp, 16
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 32 x half> @llvm.minimum.nxv32f16(<vscale x 32 x half> %a, <vscale x 32 x half> %b)
  ret <vscale x 32 x half> %v
}

declare <vscale x 1 x float> @llvm.minimum.nxv1f32(<vscale x 1 x float>, <vscale x 1 x float>)

define <vscale x 1 x float> @vfmin_nxv1f32_vv(<vscale x 1 x float> %a, <vscale x 1 x float> %b) {
; CHECK-LABEL: vfmin_nxv1f32_vv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vmerge.vvm v10, v8, v9, v0
; CHECK-NEXT:    vmfeq.vv v0, v9, v9
; CHECK-NEXT:    vmerge.vvm v8, v9, v8, v0
; CHECK-NEXT:    vfmin.vv v8, v8, v10
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x float> @llvm.minimum.nxv1f32(<vscale x 1 x float> %a, <vscale x 1 x float> %b)
  ret <vscale x 1 x float> %v
}

declare <vscale x 2 x float> @llvm.minimum.nxv2f32(<vscale x 2 x float>, <vscale x 2 x float>)

define <vscale x 2 x float> @vfmin_nxv2f32_vv(<vscale x 2 x float> %a, <vscale x 2 x float> %b) {
; CHECK-LABEL: vfmin_nxv2f32_vv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vmerge.vvm v10, v8, v9, v0
; CHECK-NEXT:    vmfeq.vv v0, v9, v9
; CHECK-NEXT:    vmerge.vvm v8, v9, v8, v0
; CHECK-NEXT:    vfmin.vv v8, v8, v10
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x float> @llvm.minimum.nxv2f32(<vscale x 2 x float> %a, <vscale x 2 x float> %b)
  ret <vscale x 2 x float> %v
}

declare <vscale x 4 x float> @llvm.minimum.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>)

define <vscale x 4 x float> @vfmin_nxv4f32_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b) {
; CHECK-LABEL: vfmin_nxv4f32_vv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vmerge.vvm v12, v8, v10, v0
; CHECK-NEXT:    vmfeq.vv v0, v10, v10
; CHECK-NEXT:    vmerge.vvm v8, v10, v8, v0
; CHECK-NEXT:    vfmin.vv v8, v8, v12
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x float> @llvm.minimum.nxv4f32(<vscale x 4 x float> %a, <vscale x 4 x float> %b)
  ret <vscale x 4 x float> %v
}

declare <vscale x 8 x float> @llvm.minimum.nxv8f32(<vscale x 8 x float>, <vscale x 8 x float>)

define <vscale x 8 x float> @vfmin_nxv8f32_vv(<vscale x 8 x float> %a, <vscale x 8 x float> %b) {
; CHECK-LABEL: vfmin_nxv8f32_vv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vmerge.vvm v16, v8, v12, v0
; CHECK-NEXT:    vmfeq.vv v0, v12, v12
; CHECK-NEXT:    vmerge.vvm v8, v12, v8, v0
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x float> @llvm.minimum.nxv8f32(<vscale x 8 x float> %a, <vscale x 8 x float> %b)
  ret <vscale x 8 x float> %v
}

declare <vscale x 16 x float> @llvm.minimum.nxv16f32(<vscale x 16 x float>, <vscale x 16 x float>)

define <vscale x 16 x float> @vfmin_nxv16f32_vv(<vscale x 16 x float> %a, <vscale x 16 x float> %b) nounwind {
; CHECK-LABEL: vfmin_nxv16f32_vv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vmfeq.vv v7, v16, v16
; CHECK-NEXT:    vmerge.vvm v24, v8, v16, v0
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vmerge.vvm v8, v16, v8, v0
; CHECK-NEXT:    vfmin.vv v8, v8, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x float> @llvm.minimum.nxv16f32(<vscale x 16 x float> %a, <vscale x 16 x float> %b)
  ret <vscale x 16 x float> %v
}

declare <vscale x 1 x double> @llvm.minimum.nxv1f64(<vscale x 1 x double>, <vscale x 1 x double>)

define <vscale x 1 x double> @vfmin_nxv1f64_vv(<vscale x 1 x double> %a, <vscale x 1 x double> %b) {
; CHECK-LABEL: vfmin_nxv1f64_vv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vmerge.vvm v10, v8, v9, v0
; CHECK-NEXT:    vmfeq.vv v0, v9, v9
; CHECK-NEXT:    vmerge.vvm v8, v9, v8, v0
; CHECK-NEXT:    vfmin.vv v8, v8, v10
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x double> @llvm.minimum.nxv1f64(<vscale x 1 x double> %a, <vscale x 1 x double> %b)
  ret <vscale x 1 x double> %v
}

declare <vscale x 2 x double> @llvm.minimum.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>)

define <vscale x 2 x double> @vfmin_nxv2f64_vv(<vscale x 2 x double> %a, <vscale x 2 x double> %b) {
; CHECK-LABEL: vfmin_nxv2f64_vv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vmerge.vvm v12, v8, v10, v0
; CHECK-NEXT:    vmfeq.vv v0, v10, v10
; CHECK-NEXT:    vmerge.vvm v8, v10, v8, v0
; CHECK-NEXT:    vfmin.vv v8, v8, v12
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x double> @llvm.minimum.nxv2f64(<vscale x 2 x double> %a, <vscale x 2 x double> %b)
  ret <vscale x 2 x double> %v
}

declare <vscale x 4 x double> @llvm.minimum.nxv4f64(<vscale x 4 x double>, <vscale x 4 x double>)

define <vscale x 4 x double> @vfmin_nxv4f64_vv(<vscale x 4 x double> %a, <vscale x 4 x double> %b) {
; CHECK-LABEL: vfmin_nxv4f64_vv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vmerge.vvm v16, v8, v12, v0
; CHECK-NEXT:    vmfeq.vv v0, v12, v12
; CHECK-NEXT:    vmerge.vvm v8, v12, v8, v0
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x double> @llvm.minimum.nxv4f64(<vscale x 4 x double> %a, <vscale x 4 x double> %b)
  ret <vscale x 4 x double> %v
}

declare <vscale x 8 x double> @llvm.minimum.nxv8f64(<vscale x 8 x double>, <vscale x 8 x double>)

define <vscale x 8 x double> @vfmin_nxv8f64_vv(<vscale x 8 x double> %a, <vscale x 8 x double> %b) nounwind {
; CHECK-LABEL: vfmin_nxv8f64_vv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vmfeq.vv v7, v16, v16
; CHECK-NEXT:    vmerge.vvm v24, v8, v16, v0
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vmerge.vvm v8, v16, v8, v0
; CHECK-NEXT:    vfmin.vv v8, v8, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x double> @llvm.minimum.nxv8f64(<vscale x 8 x double> %a, <vscale x 8 x double> %b)
  ret <vscale x 8 x double> %v
}

define <vscale x 1 x half> @vfmin_nxv1f16_vv_nnan(<vscale x 1 x half> %a, <vscale x 1 x half> %b) {
; ZVFH-LABEL: vfmin_nxv1f16_vv_nnan:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfmin.vv v8, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfmin_nxv1f16_vv_nnan:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmin.vv v9, v9, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %v = call nnan <vscale x 1 x half> @llvm.minimum.nxv1f16(<vscale x 1 x half> %a, <vscale x 1 x half> %b)
  ret <vscale x 1 x half> %v
}

define <vscale x 1 x half> @vfmin_nxv1f16_vv_nnana(<vscale x 1 x half> %a, <vscale x 1 x half> %b) {
; ZVFH-LABEL: vfmin_nxv1f16_vv_nnana:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; ZVFH-NEXT:    vmfeq.vv v0, v9, v9
; ZVFH-NEXT:    vmv1r.v v10, v9
; ZVFH-NEXT:    vfadd.vv v10, v8, v8, v0.t
; ZVFH-NEXT:    vfmin.vv v8, v10, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfmin_nxv1f16_vv_nnana:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfadd.vv v9, v10, v10
; ZVFHMIN-NEXT:    vmfeq.vv v0, v8, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vmv1r.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmin.vv v9, v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %c = fadd nnan <vscale x 1 x half> %a, %a
  %v = call <vscale x 1 x half> @llvm.minimum.nxv1f16(<vscale x 1 x half> %c, <vscale x 1 x half> %b)
  ret <vscale x 1 x half> %v
}

define <vscale x 1 x half> @vfmin_nxv1f16_vv_nnanb(<vscale x 1 x half> %a, <vscale x 1 x half> %b) {
; ZVFH-LABEL: vfmin_nxv1f16_vv_nnanb:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; ZVFH-NEXT:    vmfeq.vv v0, v8, v8
; ZVFH-NEXT:    vmv1r.v v10, v8
; ZVFH-NEXT:    vfadd.vv v10, v9, v9, v0.t
; ZVFH-NEXT:    vfmin.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfmin_nxv1f16_vv_nnanb:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfadd.vv v8, v10, v10
; ZVFHMIN-NEXT:    vmfeq.vv v0, v9, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v8
; ZVFHMIN-NEXT:    vmv1r.v v8, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmin.vv v9, v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %c = fadd nnan <vscale x 1 x half> %b, %b
  %v = call <vscale x 1 x half> @llvm.minimum.nxv1f16(<vscale x 1 x half> %a, <vscale x 1 x half> %c)
  ret <vscale x 1 x half> %v
}
